/*
 * Decompiled with CFR 0.152.
 */
package me.minidigger.minimessage.bungee;

import java.util.ArrayDeque;
import java.util.EnumSet;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;

public class MiniMessageParser {
    private static final String START = "start";
    private static final String TOKEN = "token";
    private static final String INNER = "inner";
    private static final String END = "end";
    private static final Pattern pattern = Pattern.compile("((?<start><)(?<token>([^<>]+)|([^<>]+\"(?<inner>[^\"]+)\"))(?<end>>))+?");

    @Nonnull
    public static String escapeTokens(@Nonnull String richMessage) {
        StringBuilder sb = new StringBuilder();
        Matcher matcher = pattern.matcher(richMessage);
        int lastEnd = 0;
        while (matcher.find()) {
            int startIndex = matcher.start();
            int endIndex = matcher.end();
            if (startIndex > lastEnd) {
                sb.append(richMessage, lastEnd, startIndex);
            }
            lastEnd = endIndex;
            String start = matcher.group(START);
            String token = matcher.group(TOKEN);
            String inner = matcher.group(INNER);
            String end = matcher.group(END);
            if (inner != null) {
                token = token.replace(inner, MiniMessageParser.escapeTokens(inner));
            }
            sb.append("\\").append(start).append(token).append("\\").append(end);
        }
        if (richMessage.length() > lastEnd) {
            sb.append(richMessage.substring(lastEnd));
        }
        return sb.toString();
    }

    @Nonnull
    public static String stripTokens(@Nonnull String richMessage) {
        StringBuilder sb = new StringBuilder();
        Matcher matcher = pattern.matcher(richMessage);
        int lastEnd = 0;
        while (matcher.find()) {
            int startIndex = matcher.start();
            int endIndex = matcher.end();
            if (startIndex > lastEnd) {
                sb.append(richMessage, lastEnd, startIndex);
            }
            lastEnd = endIndex;
        }
        if (richMessage.length() > lastEnd) {
            sb.append(richMessage.substring(lastEnd));
        }
        return sb.toString();
    }

    @Nonnull
    public static String handlePlaceholders(@Nonnull String richMessage, String ... placeholders) {
        if (placeholders.length % 2 != 0) {
            throw new ParseException("Invalid number placeholders defined, usage: parseFormat(format, key, value, key, value...)");
        }
        for (int i = 0; i < placeholders.length; i += 2) {
            richMessage = richMessage.replace("<" + placeholders[i] + ">", placeholders[i + 1]);
        }
        return richMessage;
    }

    @Nonnull
    public static String handlePlaceholders(@Nonnull String richMessage, @Nonnull Map<String, String> placeholders) {
        for (Map.Entry<String, String> entry : placeholders.entrySet()) {
            richMessage = richMessage.replace("<" + entry.getKey() + ">", entry.getValue());
        }
        return richMessage;
    }

    @Nonnull
    public static BaseComponent[] parseFormat(@Nonnull String richMessage, String ... placeholders) {
        return MiniMessageParser.parseFormat(MiniMessageParser.handlePlaceholders(richMessage, placeholders));
    }

    @Nonnull
    public static BaseComponent[] parseFormat(@Nonnull String richMessage, @Nonnull Map<String, String> placeholders) {
        return MiniMessageParser.parseFormat(MiniMessageParser.handlePlaceholders(richMessage, placeholders));
    }

    @Nonnull
    public static BaseComponent[] parseFormat(@Nonnull String richMessage) {
        ComponentBuilder builder = null;
        ArrayDeque<ClickEvent> clickEvents = new ArrayDeque<ClickEvent>();
        ArrayDeque<HoverEvent> hoverEvents = new ArrayDeque<HoverEvent>();
        ArrayDeque<ChatColor> colors = new ArrayDeque<ChatColor>();
        EnumSet<TextDecoration> decorations = EnumSet.noneOf(TextDecoration.class);
        Matcher matcher = pattern.matcher(richMessage);
        int lastEnd = 0;
        while (matcher.find()) {
            int startIndex = matcher.start();
            int endIndex = matcher.end();
            String msg = null;
            if (startIndex > lastEnd) {
                msg = richMessage.substring(lastEnd, startIndex);
            }
            lastEnd = endIndex;
            if (msg != null && msg.length() != 0) {
                if (builder == null) {
                    builder = new ComponentBuilder(msg);
                } else {
                    builder.append(msg, ComponentBuilder.FormatRetention.NONE);
                }
                if (!clickEvents.isEmpty()) {
                    builder.event((ClickEvent)clickEvents.peek());
                }
                if (!hoverEvents.isEmpty()) {
                    builder.event((HoverEvent)hoverEvents.peek());
                }
                if (!colors.isEmpty()) {
                    builder.color((ChatColor)colors.peek());
                }
                if (!decorations.isEmpty()) {
                    for (TextDecoration decor : decorations) {
                        decor.apply(builder);
                    }
                }
            }
            String token = matcher.group(TOKEN);
            String inner = matcher.group(INNER);
            if (token.startsWith("click:")) {
                clickEvents.push(MiniMessageParser.handleClick(token, inner));
                continue;
            }
            if (token.equals("/click")) {
                clickEvents.pop();
                continue;
            }
            if (token.startsWith("hover:")) {
                hoverEvents.push(MiniMessageParser.handleHover(token, inner));
                continue;
            }
            if (token.equals("/hover")) {
                hoverEvents.pop();
                continue;
            }
            Optional<TextDecoration> deco = MiniMessageParser.resolveDecoration(token);
            if (deco.isPresent()) {
                decorations.add(deco.get());
                continue;
            }
            if (token.startsWith("/") && (deco = MiniMessageParser.resolveDecoration(token.replace("/", ""))).isPresent()) {
                decorations.remove((Object)deco.get());
                continue;
            }
            Optional<ChatColor> color = MiniMessageParser.resolveColor(token);
            if (color.isPresent()) {
                colors.push(color.get());
                continue;
            }
            if (token.startsWith("/") && MiniMessageParser.resolveColor(token.replace("/", "")).isPresent()) {
                colors.pop();
                continue;
            }
            if (builder == null) {
                builder = new ComponentBuilder("<" + token + ">");
                continue;
            }
            builder.append("<" + token + ">", ComponentBuilder.FormatRetention.NONE);
        }
        if (richMessage.length() > lastEnd) {
            String msg = richMessage.substring(lastEnd);
            if (builder == null) {
                builder = new ComponentBuilder(msg);
            } else {
                builder.append(msg, ComponentBuilder.FormatRetention.NONE);
            }
            if (!clickEvents.isEmpty()) {
                builder.event((ClickEvent)clickEvents.peek());
            }
            if (!hoverEvents.isEmpty()) {
                builder.event((HoverEvent)hoverEvents.peek());
            }
            if (!colors.isEmpty()) {
                builder.color((ChatColor)colors.peek());
            }
            if (!decorations.isEmpty()) {
                for (TextDecoration decor : decorations) {
                    decor.apply(builder);
                }
            }
        }
        if (builder == null) {
            builder = new ComponentBuilder("");
        }
        return builder.create();
    }

    @Nonnull
    private static ClickEvent handleClick(@Nonnull String token, @Nonnull String inner) {
        String[] args = token.split(":");
        if (args.length < 2) {
            throw new ParseException("Can't parse click action (too few args) " + token);
        }
        ClickEvent.Action action = ClickEvent.Action.valueOf((String)args[1].toUpperCase());
        return new ClickEvent(action, token.replace("click:" + args[1] + ":", ""));
    }

    @Nonnull
    private static HoverEvent handleHover(@Nonnull String token, @Nonnull String inner) {
        String[] args = token.split(":");
        if (args.length < 2) {
            throw new ParseException("Can't parse hover action (too few args) " + token);
        }
        HoverEvent.Action action = HoverEvent.Action.valueOf((String)args[1].toUpperCase());
        return new HoverEvent(action, MiniMessageParser.parseFormat(inner));
    }

    @Nonnull
    private static Optional<ChatColor> resolveColor(@Nonnull String token) {
        try {
            return Optional.of(ChatColor.valueOf((String)token.toUpperCase()));
        }
        catch (IllegalArgumentException ex) {
            return Optional.empty();
        }
    }

    @Nonnull
    private static Optional<TextDecoration> resolveDecoration(@Nonnull String token) {
        try {
            return Optional.of(TextDecoration.valueOf(token.toUpperCase()));
        }
        catch (IllegalArgumentException ex) {
            return Optional.empty();
        }
    }

    static class ParseException
    extends RuntimeException {
        public ParseException(@Nonnull String message) {
            super(message);
        }
    }

    static enum TextDecoration {
        BOLD(b -> b.bold(true)),
        ITALIC(b -> b.italic(true)),
        UNDERLINED(b -> b.underlined(true)),
        STRIKETHROUGH(b -> b.strikethrough(true)),
        OBFUSCATED(b -> b.obfuscated(true));

        private final Consumer<ComponentBuilder> builder;

        private TextDecoration(Consumer<ComponentBuilder> builder) {
            this.builder = builder;
        }

        public void apply(@Nonnull ComponentBuilder comp) {
            this.builder.accept(comp);
        }
    }
}

