/*
 * Decompiled with CFR 0.152.
 */
package me.mattstudios.mf.base;

import com.google.common.primitives.Doubles;
import com.google.common.primitives.Floats;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import me.mattstudios.mf.base.components.CommandData;
import me.mattstudios.mf.base.components.ParameterResolver;
import me.mattstudios.mf.base.components.TypeResult;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.entity.Player;

public final class ParameterHandler {
    private final Map<Class<?>, ParameterResolver> registeredTypes = new HashMap();

    ParameterHandler() {
        this.register(Short.class, arg -> {
            Integer integer = Ints.tryParse((String)String.valueOf(arg));
            return integer == null ? new TypeResult(arg) : new TypeResult(integer.shortValue(), arg);
        });
        this.register(Integer.class, arg -> new TypeResult(Ints.tryParse((String)String.valueOf(arg)), arg));
        this.register(Long.class, arg -> new TypeResult(Longs.tryParse((String)String.valueOf(arg)), arg));
        this.register(Float.class, arg -> new TypeResult(Floats.tryParse((String)String.valueOf(arg)), arg));
        this.register(Double.class, arg -> new TypeResult(Doubles.tryParse((String)String.valueOf(arg)), arg));
        this.register(String.class, arg -> arg instanceof String ? new TypeResult(arg, arg) : new TypeResult(arg));
        this.register(String[].class, arg -> {
            if (arg instanceof String[]) {
                return new TypeResult(arg, arg);
            }
            return new TypeResult(arg);
        });
        this.register(Boolean.class, arg -> new TypeResult(Boolean.valueOf(String.valueOf(arg)), arg));
        this.register(Boolean.TYPE, arg -> new TypeResult(Boolean.valueOf(String.valueOf(arg)), arg));
        this.register(Player.class, arg -> new TypeResult(Bukkit.getPlayer((String)String.valueOf(arg)), arg));
        this.register(Material.class, arg -> new TypeResult(Material.matchMaterial((String)String.valueOf(arg)), arg));
        this.register(Sound.class, arg -> {
            String soundValue = Arrays.stream(Sound.values()).map(Enum::name).filter(name -> name.equalsIgnoreCase(String.valueOf(arg))).findFirst().orElse(null);
            return soundValue == null ? new TypeResult(null, arg) : new TypeResult(Sound.valueOf((String)soundValue), arg);
        });
        this.register(World.class, arg -> new TypeResult(Bukkit.getWorld((String)String.valueOf(arg)), arg));
    }

    public void register(Class<?> clss, ParameterResolver parameterResolver) {
        this.registeredTypes.put(clss, parameterResolver);
    }

    Object getTypeResult(Class<?> clss, Object object, CommandData subCommand, String paramName) {
        TypeResult result = this.registeredTypes.get(clss).resolve(object);
        subCommand.getCommandBase().addArgument(paramName, result.getArgumentName());
        return result.getResolvedValue();
    }

    boolean isRegisteredType(Class<?> clss) {
        return this.registeredTypes.get(clss) != null;
    }
}

