/*
 * Decompiled with CFR 0.152.
 */
package me.mattstudios.mf.base;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import me.mattstudios.mf.annotations.Alias;
import me.mattstudios.mf.annotations.CompleteFor;
import me.mattstudios.mf.annotations.Completion;
import me.mattstudios.mf.annotations.Default;
import me.mattstudios.mf.annotations.Optional;
import me.mattstudios.mf.annotations.Permission;
import me.mattstudios.mf.annotations.SubCommand;
import me.mattstudios.mf.annotations.Values;
import me.mattstudios.mf.annotations.WrongUsage;
import me.mattstudios.mf.base.CommandBase;
import me.mattstudios.mf.base.CompletionHandler;
import me.mattstudios.mf.base.MessageHandler;
import me.mattstudios.mf.base.ParameterHandler;
import me.mattstudios.mf.base.components.CommandData;
import me.mattstudios.mf.base.components.MfUtil;
import me.mattstudios.mf.exceptions.MfException;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;

public final class CommandHandler
extends Command {
    private final Map<String, CommandData> commands = new HashMap<String, CommandData>();
    private final ParameterHandler parameterHandler;
    private final CompletionHandler completionHandler;
    private final MessageHandler messageHandler;
    private boolean hideTab;

    CommandHandler(ParameterHandler parameterHandler, CompletionHandler completionHandler, MessageHandler messageHandler, CommandBase command, String commandName, List<String> aliases, boolean hideTab) {
        super(commandName);
        this.parameterHandler = parameterHandler;
        this.completionHandler = completionHandler;
        this.messageHandler = messageHandler;
        this.hideTab = hideTab;
        this.setAliases(aliases);
        this.addSubCommands(command);
    }

    void addSubCommands(CommandBase command) {
        for (Method method : command.getClass().getDeclaredMethods()) {
            CommandData subCommand = new CommandData(command);
            if (!method.isAnnotationPresent(Default.class) && !method.isAnnotationPresent(SubCommand.class) || !Modifier.isPublic(method.getModifiers())) continue;
            if (method.getParameterCount() == 0) {
                throw new MfException("Method " + method.getName() + " in class " + command.getClass().getName() + " - needs to have Parameters!");
            }
            if (!CommandSender.class.isAssignableFrom(method.getParameterTypes()[0])) {
                throw new MfException("Method " + method.getName() + " in class " + command.getClass().getName() + " - first parameter needs to be a CommandSender, Player, or ConsoleCommandSender!");
            }
            subCommand.setMethod(method);
            subCommand.setSenderClass(method.getParameterTypes()[0]);
            this.checkRegisteredParams(method, command, subCommand);
            this.checkDefault(method, subCommand);
            this.checkPermission(method, subCommand);
            this.checkWrongUsage(method, subCommand);
            this.checkOptionalParam(method, command, subCommand);
            this.checkMethodCompletion(method, command, subCommand);
            this.checkParamCompletion(method, command, subCommand);
            this.checkAlias(method, subCommand);
            if (!subCommand.isDefault() && method.isAnnotationPresent(SubCommand.class)) {
                String name = method.getAnnotation(SubCommand.class).value().toLowerCase();
                subCommand.setName(name);
                this.commands.put(name, subCommand);
            }
            if (subCommand.isDefault()) {
                subCommand.setName("default");
                this.commands.put("default", subCommand);
            }
            this.checkCompletionMethod(command, subCommand);
        }
    }

    public boolean execute(CommandSender sender, String label, String[] arguments) {
        CommandData subCommand = this.getDefaultSubCommand();
        if (arguments.length == 0 || arguments[0].isEmpty()) {
            if (subCommand == null) {
                return this.unknownCommand(sender);
            }
            if (subCommand.hasPermissions() && !this.hasPermissions(sender, subCommand)) {
                return this.noPermission(sender);
            }
            if (!(CommandSender.class.equals(subCommand.getSenderClass()) || ConsoleCommandSender.class.equals(subCommand.getSenderClass()) || sender instanceof Player)) {
                return this.noConsole(sender);
            }
            if (ConsoleCommandSender.class.equals(subCommand.getSenderClass()) && sender instanceof Player) {
                return this.noPlayer(sender);
            }
            return this.executeCommand(subCommand, sender, arguments);
        }
        String argCommand = arguments[0].toLowerCase();
        if (subCommand != null && subCommand.getParams().size() == 0 && (!this.commands.containsKey(argCommand) || this.getName().equalsIgnoreCase(argCommand))) {
            return this.unknownCommand(sender);
        }
        if (subCommand == null && !this.commands.containsKey(argCommand)) {
            return this.unknownCommand(sender);
        }
        if (this.commands.containsKey(argCommand)) {
            subCommand = this.commands.get(argCommand);
        }
        assert (subCommand != null);
        if (subCommand.hasPermissions() && !this.hasPermissions(sender, subCommand)) {
            return this.noPermission(sender);
        }
        if (!(CommandSender.class.equals(subCommand.getSenderClass()) || ConsoleCommandSender.class.equals(subCommand.getSenderClass()) || sender instanceof Player)) {
            return this.noConsole(sender);
        }
        if (ConsoleCommandSender.class.equals(subCommand.getSenderClass()) && sender instanceof Player) {
            return this.noPlayer(sender);
        }
        return this.executeCommand(subCommand, sender, arguments);
    }

    private boolean executeCommand(CommandData subCommand, CommandSender sender, String[] arguments) {
        try {
            Method method = subCommand.getMethod();
            LinkedList<String> argumentsList = new LinkedList<String>(Arrays.asList(arguments));
            if (!subCommand.isDefault() && argumentsList.size() > 0) {
                argumentsList.remove(0);
            }
            if (subCommand.getParams().size() == 0 && argumentsList.size() == 0) {
                method.invoke((Object)subCommand.getCommandBase(), sender);
                return true;
            }
            if (subCommand.getParams().size() == 1 && String[].class.isAssignableFrom(subCommand.getParams().get(0))) {
                method.invoke((Object)subCommand.getCommandBase(), sender, arguments);
                return true;
            }
            if (subCommand.getParams().size() != argumentsList.size() && !subCommand.hasOptional()) {
                if (!subCommand.isDefault() && subCommand.getParams().size() == 0) {
                    return this.wrongUsage(sender, subCommand);
                }
                if (!String[].class.isAssignableFrom(subCommand.getParams().get(subCommand.getParams().size() - 1))) {
                    return this.wrongUsage(sender, subCommand);
                }
            }
            ArrayList<Object> invokeParams = new ArrayList<Object>();
            invokeParams.add(sender);
            for (int i = 0; i < subCommand.getParams().size(); ++i) {
                String completionId;
                Class<?> parameter = subCommand.getParams().get(i);
                if (subCommand.hasOptional()) {
                    if (argumentsList.size() > subCommand.getParams().size()) {
                        return this.wrongUsage(sender, subCommand);
                    }
                    if (argumentsList.size() < subCommand.getParams().size() - 1) {
                        return this.wrongUsage(sender, subCommand);
                    }
                    if (argumentsList.size() < subCommand.getParams().size()) {
                        argumentsList.add(null);
                    }
                }
                if (subCommand.getParams().size() > argumentsList.size()) {
                    return this.wrongUsage(sender, subCommand);
                }
                Object argument = argumentsList.get(i);
                if (subCommand.getArgValue().contains(i + 1) && !this.completionHandler.getTypeResult(completionId = subCommand.getCompletions().get(i + 1), completionId).contains(argument)) {
                    argument = null;
                }
                if (parameter.equals(String[].class)) {
                    String[] args = new String[argumentsList.size() - i];
                    for (int j = 0; j < args.length; ++j) {
                        args[j] = (String)argumentsList.get(i + j);
                    }
                    argument = args;
                }
                Object result = this.parameterHandler.getTypeResult(parameter, argument, subCommand, subCommand.getParameterNames().get(i));
                invokeParams.add(result);
            }
            method.invoke((Object)subCommand.getCommandBase(), invokeParams.toArray());
            subCommand.getCommandBase().clearArgs();
            return true;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return true;
        }
    }

    public List<String> tabComplete(CommandSender sender, String alias, String[] args) throws IllegalArgumentException {
        String current;
        if (args.length == 1) {
            ArrayList<Object> commandNames = new ArrayList();
            CommandData subCommand = this.getDefaultSubCommand();
            ArrayList<String> subCmd = new ArrayList<String>(this.commands.keySet());
            subCmd.remove("default");
            for (String subCmdName : this.commands.keySet()) {
                CommandData subCmdData = this.commands.get(subCmdName);
                if (!this.hideTab || !subCmdData.hasPermissions() || this.hasPermissions(sender, subCmdData)) continue;
                subCmd.remove(subCmdName);
            }
            if (subCommand != null && subCommand.getCompletions().size() != 0) {
                Object id = subCommand.getCompletions().get(1);
                Object inputClss = subCommand.getParams().get(0);
                if (((String)id).contains(":")) {
                    String[] values = ((String)id).split(":");
                    id = values[0];
                    inputClss = values[1];
                }
                subCmd.addAll(this.completionHandler.getTypeResult((String)id, inputClss));
            }
            if (!"".equals(args[0])) {
                for (String commandName : subCmd) {
                    if (!commandName.toLowerCase().startsWith(args[0].toLowerCase())) continue;
                    commandNames.add(commandName);
                }
            } else {
                commandNames = subCmd;
            }
            Collections.sort(commandNames);
            if (commandNames.isEmpty()) {
                return super.tabComplete(sender, alias, args);
            }
            return commandNames;
        }
        String subCommandArg = args[0];
        if (!this.commands.containsKey(subCommandArg)) {
            return super.tabComplete(sender, alias, args);
        }
        CommandData subCommand = this.commands.get(subCommandArg);
        if (this.hideTab && subCommand.hasPermissions() && !this.hasPermissions(sender, subCommand)) {
            return super.tabComplete(sender, alias, args);
        }
        Method completionMethod = subCommand.getCompletionMethod();
        if (completionMethod != null) {
            try {
                LinkedList<String> argsList = new LinkedList<String>(Arrays.asList(args));
                argsList.remove(subCommandArg);
                return (List)completionMethod.invoke((Object)subCommand.getCommandBase(), argsList);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        if (!subCommand.getCompletions().containsKey(args.length - 1)) {
            return super.tabComplete(sender, alias, args);
        }
        String id = subCommand.getCompletions().get(args.length - 1);
        ArrayList<String> completionList = new ArrayList();
        Object inputClss = subCommand.getParams().get(args.length - 2);
        if (id.contains(":")) {
            String[] values = id.split(":");
            id = values[0];
            inputClss = values[1];
        }
        if (!"".equals(current = args[args.length - 1])) {
            for (String completion : this.completionHandler.getTypeResult(id, inputClss)) {
                if (!completion.toLowerCase().contains(current.toLowerCase())) continue;
                completionList.add(completion);
            }
        } else {
            completionList = new ArrayList<String>(this.completionHandler.getTypeResult(id, inputClss));
        }
        Collections.sort(completionList);
        return completionList;
    }

    public void setHideTab(boolean hideTab) {
        this.hideTab = hideTab;
    }

    private CommandData getDefaultSubCommand() {
        return this.commands.getOrDefault("default", null);
    }

    private void checkDefault(Method method, CommandData subCommand) {
        if (!method.isAnnotationPresent(Default.class)) {
            return;
        }
        subCommand.setDefault(true);
    }

    private void checkRegisteredParams(Method method, CommandBase command, CommandData subCommand) {
        for (int i = 1; i < method.getParameterTypes().length; ++i) {
            Class<?> clss = method.getParameterTypes()[i];
            if (clss.equals(String[].class) && i != method.getParameterTypes().length - 1) {
                throw new MfException("Method " + method.getName() + " in class " + command.getClass().getName() + " 'String[] args' have to be the last parameter if wants to be used!");
            }
            if (!this.parameterHandler.isRegisteredType(clss)) {
                throw new MfException("Method " + method.getName() + " in class " + command.getClass().getName() + " contains unregistered parameter types!");
            }
            subCommand.getParams().add(clss);
            subCommand.getParameterNames().add(method.getParameters()[i].getName());
        }
    }

    private void checkPermission(Method method, CommandData subCommand) {
        if (!method.isAnnotationPresent(Permission.class)) {
            return;
        }
        for (String permission : method.getAnnotation(Permission.class).value()) {
            subCommand.addPermission(permission);
        }
    }

    private void checkWrongUsage(Method method, CommandData subCommand) {
        if (!method.isAnnotationPresent(WrongUsage.class)) {
            return;
        }
        subCommand.setWrongUsage(method.getAnnotation(WrongUsage.class).value());
    }

    private void checkParamCompletion(Method method, CommandBase command, CommandData subCommand) {
        for (int i = 0; i < method.getParameters().length; ++i) {
            String[] values;
            Parameter parameter = method.getParameters()[i];
            if (i == 0 && parameter.isAnnotationPresent(Completion.class)) {
                throw new MfException("Method " + method.getName() + " in class " + command.getClass().getName() + " - First parameter of a command method cannot have Completion/Values annotation!");
            }
            if (parameter.isAnnotationPresent(Completion.class)) {
                values = parameter.getAnnotation(Completion.class).value();
            } else {
                if (!parameter.isAnnotationPresent(Values.class)) continue;
                values = new String[]{parameter.getAnnotation(Values.class).value()};
            }
            if (values.length != 1) {
                throw new MfException("Method " + method.getName() + " in class " + command.getClass().getName() + " - Parameter completion can only have one value!");
            }
            if (!values[0].startsWith("#")) {
                throw new MfException("Method " + method.getName() + " in class " + command.getClass().getName() + " - The completion ID must start with #!");
            }
            if (this.completionHandler.isNotRegistered(values[0])) {
                throw new MfException("Method " + method.getName() + " in class " + command.getClass().getName() + " - Unregistered completion ID '" + values[0] + "'!");
            }
            subCommand.getCompletions().put(i, values[0]);
            if (!parameter.isAnnotationPresent(Values.class)) continue;
            subCommand.getArgValue().add(i);
        }
    }

    private void checkMethodCompletion(Method method, CommandBase command, CommandData subCommand) {
        if (!method.isAnnotationPresent(Completion.class)) {
            return;
        }
        String[] completionValues = method.getAnnotation(Completion.class).value();
        for (int i = 0; i < completionValues.length; ++i) {
            String id = completionValues[i];
            if (!id.startsWith("#")) {
                throw new MfException("Method " + method.getName() + " in class " + command.getClass().getName() + " - The completion ID must start with #!");
            }
            if (this.completionHandler.isNotRegistered(id)) {
                throw new MfException("Method " + method.getName() + " in class " + command.getClass().getName() + " - Unregistered completion ID'" + id + "'!");
            }
            subCommand.getCompletions().put(i + 1, id);
        }
    }

    private void checkCompletionMethod(CommandBase command, CommandData subCommand) {
        for (Method method : command.getClass().getDeclaredMethods()) {
            if (!method.isAnnotationPresent(CompleteFor.class)) continue;
            if (!(method.getGenericReturnType() instanceof ParameterizedType)) {
                return;
            }
            ParameterizedType parametrizedReturnType = (ParameterizedType)method.getGenericReturnType();
            if (parametrizedReturnType.getRawType() != List.class) {
                return;
            }
            if (parametrizedReturnType.getActualTypeArguments().length != 1) {
                return;
            }
            if (parametrizedReturnType.getActualTypeArguments()[0] != String.class) {
                return;
            }
            String subCommandName = method.getAnnotation(CompleteFor.class).value();
            if (!subCommandName.equalsIgnoreCase(subCommand.getName())) continue;
            subCommand.setCompletionMethod(method);
        }
    }

    private void checkAlias(Method method, CommandData subCommand) {
        if (!method.isAnnotationPresent(Alias.class)) {
            return;
        }
        for (String alias : method.getAnnotation(Alias.class).value()) {
            CommandData aliasCD = subCommand;
            subCommand.setName(alias.toLowerCase());
            if (aliasCD.isDefault()) {
                aliasCD.setDefault(false);
            }
            this.commands.put(alias.toLowerCase(), subCommand);
        }
    }

    private void checkOptionalParam(Method method, CommandBase command, CommandData subCommand) {
        for (int i = 0; i < method.getParameters().length; ++i) {
            Parameter parameter = method.getParameters()[i];
            if (i != method.getParameters().length - 1 && parameter.isAnnotationPresent(Optional.class)) {
                throw new MfException("Method " + method.getName() + " in class " + command.getClass().getName() + " - Optional parameters can only be used as the last parameter of a method!");
            }
            if (!parameter.isAnnotationPresent(Optional.class)) continue;
            subCommand.setOptional(true);
        }
    }

    private boolean hasPermissions(CommandSender sender, CommandData subCommand) {
        for (String permission : subCommand.getPermissions()) {
            if (!sender.hasPermission(permission)) continue;
            return true;
        }
        return false;
    }

    private boolean wrongUsage(CommandSender sender, CommandData subCommand) {
        String wrongMessage = subCommand.getWrongUsage();
        if (wrongMessage == null) {
            this.messageHandler.sendMessage("cmd.wrong.usage", sender);
            return true;
        }
        if (!wrongMessage.startsWith("#") || !this.messageHandler.hasId(wrongMessage)) {
            this.messageHandler.sendMessage("cmd.wrong.usage", sender);
            sender.sendMessage(MfUtil.color(subCommand.getWrongUsage()));
            return true;
        }
        this.messageHandler.sendMessage(wrongMessage, sender);
        return true;
    }

    private boolean unknownCommand(CommandSender sender) {
        this.messageHandler.sendMessage("cmd.no.exists", sender);
        return true;
    }

    private boolean noPermission(CommandSender sender) {
        this.messageHandler.sendMessage("cmd.no.permission", sender);
        return true;
    }

    private boolean noConsole(CommandSender sender) {
        this.messageHandler.sendMessage("cmd.no.console", sender);
        return true;
    }

    private boolean noPlayer(CommandSender sender) {
        this.messageHandler.sendMessage("cmd.no.player", sender);
        return true;
    }
}

