/*
 * Decompiled with CFR 0.152.
 */
package me.mattstudios.mf.base;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import me.mattstudios.mf.annotations.Alias;
import me.mattstudios.mf.annotations.Command;
import me.mattstudios.mf.base.CommandBase;
import me.mattstudios.mf.base.CommandHandler;
import me.mattstudios.mf.base.CompletionHandler;
import me.mattstudios.mf.base.MessageHandler;
import me.mattstudios.mf.base.ParameterHandler;
import me.mattstudios.mf.exceptions.MfException;
import org.bukkit.Bukkit;
import org.bukkit.Server;
import org.bukkit.command.CommandMap;
import org.bukkit.command.PluginIdentifiableCommand;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.plugin.Plugin;

public final class CommandManager
implements Listener {
    private final Plugin plugin;
    private final CommandMap commandMap;
    private final Map<String, CommandHandler> commands = new HashMap<String, CommandHandler>();
    private Map<String, org.bukkit.command.Command> bukkitCommands = new HashMap<String, org.bukkit.command.Command>();
    private final ParameterHandler parameterHandler = new ParameterHandler();
    private final CompletionHandler completionHandler = new CompletionHandler();
    private final MessageHandler messageHandler = new MessageHandler();
    private boolean hideTab;
    private boolean completePlayers = false;

    public CommandManager(Plugin plugin) {
        this(plugin, false);
    }

    public CommandManager(Plugin plugin, boolean hideTab) {
        this.plugin = plugin;
        plugin.getServer().getPluginManager().registerEvents((Listener)this, plugin);
        this.hideTab = hideTab;
        this.commandMap = this.getCommandMap();
    }

    public ParameterHandler getParameterHandler() {
        return this.parameterHandler;
    }

    public CompletionHandler getCompletionHandler() {
        return this.completionHandler;
    }

    public MessageHandler getMessageHandler() {
        return this.messageHandler;
    }

    public void register(CommandBase ... commands) {
        for (CommandBase command : commands) {
            this.register(command);
        }
    }

    public void register(CommandBase command) {
        org.bukkit.command.Command oldCommand;
        command.onRegister();
        Class<?> commandClass = command.getClass();
        if (!commandClass.isAnnotationPresent(Command.class)) {
            throw new MfException("Class " + command.getClass().getName() + " needs to have @Command!");
        }
        String commandName = commandClass.getAnnotation(Command.class).value();
        List<String> aliases = command.getAliases();
        if (commandClass.isAnnotationPresent(Alias.class)) {
            aliases.addAll(Arrays.asList(commandClass.getAnnotation(Alias.class).value()));
        }
        if ((oldCommand = this.commandMap.getCommand(commandName)) instanceof PluginIdentifiableCommand && ((PluginIdentifiableCommand)oldCommand).getPlugin() == this.plugin) {
            this.bukkitCommands.remove(commandName);
            oldCommand.unregister(this.commandMap);
        }
        try {
            if (this.commands.containsKey(commandName)) {
                this.commands.get(commandName).addSubCommands(command);
                return;
            }
            command.setMessageHandler(this.messageHandler);
            CommandHandler commandHandler = new CommandHandler(this.parameterHandler, this.completionHandler, this.messageHandler, command, commandName, aliases, this.hideTab, this.completePlayers);
            this.commandMap.register(commandName, this.plugin.getName(), (org.bukkit.command.Command)commandHandler);
            this.commands.put(commandName, commandHandler);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void hideTabComplete(boolean hideTab) {
        this.hideTab = hideTab;
        for (String cmdName : this.commands.keySet()) {
            this.commands.get(cmdName).setHideTab(hideTab);
        }
    }

    public void setCompletePlayers(boolean completePlayers) {
        this.completePlayers = completePlayers;
        for (String cmdName : this.commands.keySet()) {
            this.commands.get(cmdName).setCompletePlayers(completePlayers);
        }
    }

    @EventHandler
    public void onPluginDisable(PluginDisableEvent event) {
        if (event.getPlugin() != this.plugin) {
            return;
        }
        this.unregisterAll();
    }

    private void unregisterAll() {
        this.commands.values().forEach(command -> command.unregister(this.commandMap));
    }

    private CommandMap getCommandMap() {
        CommandMap commandMap = null;
        try {
            Server server = Bukkit.getServer();
            Method getCommandMap = server.getClass().getDeclaredMethod("getCommandMap", new Class[0]);
            getCommandMap.setAccessible(true);
            commandMap = (CommandMap)getCommandMap.invoke((Object)server, new Object[0]);
            Field bukkitCommands = SimpleCommandMap.class.getDeclaredField("knownCommands");
            bukkitCommands.setAccessible(true);
            this.bukkitCommands = (Map)bukkitCommands.get(commandMap);
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.SEVERE, "Could not get Command Map, Commands won't be registered!");
        }
        return commandMap;
    }
}

