/*
 * Decompiled with CFR 0.152.
 */
package me.mattstudios.mfgui.gui.guis;

import java.util.UUID;
import me.mattstudios.mfgui.gui.components.GuiAction;
import me.mattstudios.mfgui.gui.components.ItemNBT;
import org.apache.commons.lang.Validate;
import org.bukkit.Material;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GuiItem {
    private GuiAction<InventoryClickEvent> action;
    private ItemStack itemStack;
    private final UUID uuid = UUID.randomUUID();

    public GuiItem(@NotNull ItemStack itemStack, GuiAction<InventoryClickEvent> action) {
        Validate.notNull((Object)itemStack, (String)"The ItemStack for the GUI Item cannot be null!");
        this.action = action;
        this.itemStack = ItemNBT.setNBTTag(itemStack, "mf-gui", this.uuid.toString());
    }

    public GuiItem(@NotNull ItemStack itemStack) {
        this(itemStack, null);
    }

    public GuiItem(@NotNull Material material) {
        this(new ItemStack(material), null);
    }

    public GuiItem(@NotNull Material material, @Nullable GuiAction<InventoryClickEvent> action) {
        this(new ItemStack(material), action);
    }

    public void setItemStack(@NotNull ItemStack itemStack) {
        Validate.notNull((Object)itemStack, (String)"The ItemStack for the GUI Item cannot be null!");
        this.itemStack = ItemNBT.setNBTTag(itemStack, "mf-gui", this.uuid.toString());
    }

    public void setAction(GuiAction<InventoryClickEvent> action) {
        this.action = action;
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    UUID getUuid() {
        return this.uuid;
    }

    @Nullable
    GuiAction<InventoryClickEvent> getAction() {
        return this.action;
    }
}

