/*
 * Decompiled with CFR 0.152.
 */
package me.mattstudios.mfgui.gui.components.util;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import me.mattstudios.mfgui.gui.components.GuiAction;
import me.mattstudios.mfgui.gui.components.ServerVersion;
import me.mattstudios.mfgui.gui.components.exception.GuiException;
import me.mattstudios.mfgui.gui.components.util.ItemNBT;
import me.mattstudios.mfgui.gui.components.xseries.XMaterial;
import me.mattstudios.mfgui.gui.guis.GuiItem;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.jetbrains.annotations.NotNull;

public final class ItemBuilder {
    private ItemStack itemStack;
    private ItemMeta meta;

    public static ItemBuilder from(@NotNull ItemStack itemStack) {
        return new ItemBuilder(itemStack);
    }

    public static ItemBuilder from(@NotNull Material material) {
        return new ItemBuilder(material);
    }

    @Deprecated
    public ItemBuilder(@NotNull ItemStack itemStack) {
        Validate.notNull((Object)itemStack, (String)"Item can't be null!");
        this.itemStack = itemStack;
        this.meta = itemStack.hasItemMeta() ? itemStack.getItemMeta() : Bukkit.getItemFactory().getItemMeta(itemStack.getType());
    }

    @Deprecated
    public ItemBuilder(Material material) {
        this(new ItemStack(material));
    }

    public ItemStack build() {
        this.itemStack.setItemMeta(this.meta);
        return this.itemStack;
    }

    public GuiItem asGuiItem() {
        return new GuiItem(this.build());
    }

    public GuiItem asGuiItem(@NotNull GuiAction<InventoryClickEvent> action) {
        return new GuiItem(this.build(), action);
    }

    public ItemBuilder setName(@NotNull String name) {
        this.meta.setDisplayName(name);
        return this;
    }

    public ItemBuilder setAmount(int amount) {
        this.itemStack.setAmount(amount);
        return this;
    }

    public ItemBuilder setLore(String ... lore) {
        this.meta.setLore(Arrays.asList(lore));
        return this;
    }

    public ItemBuilder setLore(@NotNull List<String> lore) {
        this.meta.setLore(lore);
        return this;
    }

    public ItemBuilder addEnchantment(@NotNull Enchantment enchantment, int level, boolean ignoreLevelRestriction) {
        this.meta.addEnchant(enchantment, level, ignoreLevelRestriction);
        return this;
    }

    public ItemBuilder addEnchantment(@NotNull Enchantment enchantment, int level) {
        return this.addEnchantment(enchantment, level, true);
    }

    public ItemBuilder addEnchantment(@NotNull Enchantment enchantment) {
        return this.addEnchantment(enchantment, 1, true);
    }

    public ItemBuilder removeEnchantment(@NotNull Enchantment enchantment) {
        this.itemStack.removeEnchantment(enchantment);
        return this;
    }

    public ItemBuilder addItemFlags(ItemFlag ... flags) {
        this.meta.addItemFlags(flags);
        return this;
    }

    public ItemBuilder setUnbreakable(boolean unbreakable) {
        if (ServerVersion.CURRENT_VERSION.isOlderThan(ServerVersion.V1_12_R1)) {
            throw new GuiException("setUnbreakable is not supported on versions below 1.12!");
        }
        this.meta.setUnbreakable(true);
        return this;
    }

    public ItemBuilder glow(boolean glow) {
        if (glow) {
            this.meta.addEnchant(Enchantment.LURE, 1, false);
            this.meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
            return this;
        }
        for (Enchantment enchantment : this.meta.getEnchants().keySet()) {
            this.meta.removeEnchant(enchantment);
        }
        return this;
    }

    public ItemBuilder setSkullTexture(@NotNull String texture) {
        if (this.itemStack.getType() != XMaterial.PLAYER_HEAD.parseMaterial()) {
            return this;
        }
        SkullMeta skullMeta = (SkullMeta)this.meta;
        GameProfile profile = new GameProfile(UUID.randomUUID(), null);
        profile.getProperties().put((Object)"textures", (Object)new Property("textures", texture));
        try {
            Field profileField = skullMeta.getClass().getDeclaredField("profile");
            profileField.setAccessible(true);
            profileField.set(skullMeta, profile);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException ex) {
            ex.printStackTrace();
        }
        this.meta = skullMeta;
        return this;
    }

    public ItemBuilder setSkullOwner(@NotNull OfflinePlayer player) {
        if (this.itemStack.getType() != XMaterial.PLAYER_HEAD.parseMaterial()) {
            return this;
        }
        SkullMeta skullMeta = (SkullMeta)this.meta;
        skullMeta.setOwningPlayer(player);
        this.meta = skullMeta;
        return this;
    }

    public ItemBuilder setNbt(@NotNull String key, @NotNull String value) {
        this.itemStack = ItemNBT.setNBTTag(this.itemStack, key, value);
        return this;
    }
}

