/*
 * Decompiled with CFR 0.152.
 */
package me.mattstudios.mfgui.gui.components;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Objects;
import me.mattstudios.mfgui.gui.components.ServerVersion;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public final class ItemNBT {
    private static Method getStringMethod;
    private static Method setStringMethod;
    private static Method hasTagMethod;
    private static Method getTagMethod;
    private static Method setTagMethod;
    private static Method asNMSCopyMethod;
    private static Method asBukkitCopyMethod;
    private static Constructor<?> nbtCompoundConstructor;

    public static ItemStack setNBTTag(ItemStack itemStack, String key, String value) {
        if (itemStack == null || itemStack.getType() == Material.AIR) {
            return itemStack;
        }
        Object nmsItemStack = ItemNBT.asNMSCopy(itemStack);
        Object itemCompound = ItemNBT.hasTag(nmsItemStack) ? ItemNBT.getTag(nmsItemStack) : ItemNBT.newNBTTagCompound();
        ItemNBT.setString(itemCompound, key, value);
        ItemNBT.setTag(nmsItemStack, itemCompound);
        return ItemNBT.asBukkitCopy(nmsItemStack);
    }

    public static String getNBTTag(ItemStack itemStack, String key) {
        if (itemStack == null || itemStack.getType() == Material.AIR) {
            return "";
        }
        Object nmsItemStack = ItemNBT.asNMSCopy(itemStack);
        Object itemCompound = ItemNBT.hasTag(nmsItemStack) ? ItemNBT.getTag(nmsItemStack) : ItemNBT.newNBTTagCompound();
        return ItemNBT.getString(itemCompound, key);
    }

    private static void setString(Object itemCompound, String key, String value) {
        try {
            setStringMethod.invoke(itemCompound, key, value);
        }
        catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
    }

    private static String getString(Object itemCompound, String key) {
        try {
            return (String)getStringMethod.invoke(itemCompound, key);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            return null;
        }
    }

    private static boolean hasTag(Object nmsItemStack) {
        try {
            return (Boolean)hasTagMethod.invoke(nmsItemStack, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            return false;
        }
    }

    private static Object getTag(Object nmsItemStack) {
        try {
            return getTagMethod.invoke(nmsItemStack, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            return null;
        }
    }

    private static void setTag(Object nmsItemStack, Object itemCompound) {
        try {
            setTagMethod.invoke(nmsItemStack, itemCompound);
        }
        catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
    }

    private static Object newNBTTagCompound() {
        try {
            return nbtCompoundConstructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            return null;
        }
    }

    private static Object asNMSCopy(ItemStack itemStack) {
        try {
            return asNMSCopyMethod.invoke(null, itemStack);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            return null;
        }
    }

    private static ItemStack asBukkitCopy(Object nmsItemStack) {
        try {
            return (ItemStack)asBukkitCopyMethod.invoke(null, nmsItemStack);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            return null;
        }
    }

    private static Class<?> getNMSClass(String className) {
        try {
            return Class.forName("net.minecraft.server." + ServerVersion.NMS_VERSION + "." + className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private static Class<?> getCraftItemStackClass() {
        try {
            return Class.forName("org.bukkit.craftbukkit." + ServerVersion.NMS_VERSION + ".inventory.CraftItemStack");
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    static {
        try {
            getStringMethod = Objects.requireNonNull(ItemNBT.getNMSClass("NBTTagCompound")).getMethod("getString", String.class);
            setStringMethod = Objects.requireNonNull(ItemNBT.getNMSClass("NBTTagCompound")).getMethod("setString", String.class, String.class);
            hasTagMethod = Objects.requireNonNull(ItemNBT.getNMSClass("ItemStack")).getMethod("hasTag", new Class[0]);
            getTagMethod = Objects.requireNonNull(ItemNBT.getNMSClass("ItemStack")).getMethod("getTag", new Class[0]);
            setTagMethod = Objects.requireNonNull(ItemNBT.getNMSClass("ItemStack")).getMethod("setTag", ItemNBT.getNMSClass("NBTTagCompound"));
            nbtCompoundConstructor = Objects.requireNonNull(ItemNBT.getNMSClass("NBTTagCompound")).getDeclaredConstructor(new Class[0]);
            asNMSCopyMethod = Objects.requireNonNull(ItemNBT.getCraftItemStackClass()).getMethod("asNMSCopy", ItemStack.class);
            asBukkitCopyMethod = Objects.requireNonNull(ItemNBT.getCraftItemStackClass()).getMethod("asBukkitCopy", ItemNBT.getNMSClass("ItemStack"));
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
    }
}

