/*
 * Decompiled with CFR 0.152.
 */
package me.mattstudios.mfgui.gui.guis;

import java.util.UUID;
import me.mattstudios.mfgui.gui.components.GuiAction;
import me.mattstudios.mfgui.gui.components.ItemNBT;
import org.apache.commons.lang.Validate;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public final class GuiItem {
    private GuiAction<InventoryClickEvent> action;
    private ItemStack itemStack;
    private final UUID uuid = UUID.randomUUID();

    public GuiItem(@NotNull ItemStack itemStack, GuiAction<InventoryClickEvent> action) {
        Validate.notNull((Object)itemStack, (String)"The itemstack for the GUI Item cannot be null!");
        this.action = action == null ? event -> {} : action;
        this.itemStack = ItemNBT.setNBTTag(itemStack, "mf-gui", this.uuid.toString());
    }

    public GuiItem(@NotNull ItemStack itemStack) {
        this(itemStack, null);
    }

    public void setItemStack(@NotNull ItemStack itemStack) {
        Validate.notNull((Object)itemStack, (String)"The itemstack for the GUI Item cannot be null!");
        this.itemStack = ItemNBT.setNBTTag(itemStack, "mf-gui", this.uuid.toString());
    }

    public void setAction(GuiAction<InventoryClickEvent> action) {
        this.action = action;
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    UUID getUuid() {
        return this.uuid;
    }

    GuiAction<InventoryClickEvent> getAction() {
        return this.action;
    }
}

