/*
 * Decompiled with CFR 0.152.
 */
package me.mattstudios.mfgui.gui.guis;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.mattstudios.mfgui.gui.components.GuiAction;
import me.mattstudios.mfgui.gui.components.GuiException;
import me.mattstudios.mfgui.gui.components.GuiFiller;
import me.mattstudios.mfgui.gui.guis.GuiItem;
import me.mattstudios.mfgui.gui.guis.GuiListener;
import org.bukkit.Bukkit;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public abstract class BaseGui
implements InventoryHolder {
    private final Plugin plugin;
    private Inventory inventory;
    private final GuiFiller filler = new GuiFiller(this);
    private String title;
    private int rows;
    private final Map<Integer, GuiItem> guiItems = new HashMap<Integer, GuiItem>();
    private final Map<Integer, GuiAction<InventoryClickEvent>> slotActions = new HashMap<Integer, GuiAction<InventoryClickEvent>>();
    private GuiAction<InventoryClickEvent> defaultClickAction;
    private GuiAction<InventoryClickEvent> defaultTopClickAction;
    private GuiAction<InventoryDragEvent> dragAction;
    private GuiAction<InventoryCloseEvent> closeGuiAction;
    private GuiAction<InventoryOpenEvent> openGuiAction;
    private GuiAction<InventoryClickEvent> outsideClickAction;
    private static boolean registeredListener;
    private boolean updating;

    public BaseGui(@NotNull Plugin plugin, int rows, @NotNull String title) {
        int finalRows = rows;
        if (rows < 1 || rows > 6) {
            finalRows = 1;
        }
        this.plugin = plugin;
        this.rows = finalRows;
        this.title = title;
        this.inventory = Bukkit.createInventory((InventoryHolder)this, (int)(this.rows * 9), (String)title);
        if (!registeredListener) {
            Bukkit.getPluginManager().registerEvents((Listener)new GuiListener(plugin), plugin);
            registeredListener = true;
        }
    }

    public BaseGui(@NotNull Plugin plugin, @NotNull String title) {
        this(plugin, 1, title);
    }

    public BaseGui setRows(int rows) {
        int finalRows = rows;
        if (rows < 1 || rows > 6) {
            finalRows = 1;
        }
        this.rows = finalRows;
        this.updating = true;
        ArrayList viewers = new ArrayList(this.inventory.getViewers());
        this.inventory = Bukkit.createInventory((InventoryHolder)this, (int)(this.rows * 9), (String)this.title);
        for (HumanEntity player : viewers) {
            this.open(player);
        }
        this.updating = false;
        return this;
    }

    public BaseGui setItem(int slot, @NotNull GuiItem guiItem) {
        if (!this.isValidSlot(slot)) {
            throw new GuiException("Invalid item slot!");
        }
        this.guiItems.put(slot, guiItem);
        return this;
    }

    public BaseGui setItem(@NotNull List<Integer> slots, @NotNull GuiItem guiItem) {
        for (int slot : slots) {
            this.setItem(slot, guiItem);
        }
        return this;
    }

    public BaseGui setItem(int row, int col, @NotNull GuiItem guiItem) {
        return this.setItem(this.getSlotFromRowCol(row, col), guiItem);
    }

    public BaseGui addItem(GuiItem ... items) {
        block0: for (GuiItem guiItem : items) {
            for (int slot = 0; slot < this.rows * 9; ++slot) {
                if (this.guiItems.get(slot) != null) continue;
                this.guiItems.put(slot, guiItem);
                continue block0;
            }
        }
        return this;
    }

    public BaseGui setDefaultClickAction(GuiAction<InventoryClickEvent> defaultClickAction) {
        this.defaultClickAction = defaultClickAction;
        return this;
    }

    public BaseGui setDefaultTopClickAction(GuiAction<InventoryClickEvent> defaultTopClickAction) {
        this.defaultTopClickAction = defaultTopClickAction;
        return this;
    }

    public BaseGui setDragAction(GuiAction<InventoryDragEvent> dragAction) {
        this.dragAction = dragAction;
        return this;
    }

    public BaseGui setCloseGuiAction(GuiAction<InventoryCloseEvent> closeGuiAction) {
        this.closeGuiAction = closeGuiAction;
        return this;
    }

    public BaseGui setOutsideClickAction(GuiAction<InventoryClickEvent> outsideClickAction) {
        this.outsideClickAction = outsideClickAction;
        return this;
    }

    public BaseGui setOpenGuiAction(GuiAction<InventoryOpenEvent> openGuiAction) {
        this.openGuiAction = openGuiAction;
        return this;
    }

    public BaseGui addSlotAction(int slot, GuiAction<InventoryClickEvent> slotAction) {
        if (!this.isValidSlot(slot)) {
            return this;
        }
        this.slotActions.put(slot, slotAction);
        return this;
    }

    public BaseGui addSlotAction(int row, int col, GuiAction<InventoryClickEvent> slotAction) {
        return this.addSlotAction(this.getSlotFromRowCol(row, col), slotAction);
    }

    public GuiItem getGuiItem(int slot) {
        return this.isValidSlot(slot) ? this.guiItems.get(slot) : null;
    }

    public boolean isUpdating() {
        return this.updating;
    }

    public void setUpdating(boolean updating) {
        this.updating = updating;
    }

    public void open(@NotNull HumanEntity player) {
        this.inventory.clear();
        this.populateGui();
        player.openInventory(this.inventory);
    }

    public void close(@NotNull Player player) {
        Bukkit.getScheduler().runTaskLater(this.plugin, () -> ((Player)player).closeInventory(), 2L);
    }

    public void update() {
        this.inventory.clear();
        this.populateGui();
        for (HumanEntity viewer : new ArrayList(this.inventory.getViewers())) {
            ((Player)viewer).updateInventory();
        }
    }

    public void updateItem(int slot, @NotNull ItemStack itemStack) {
        if (!this.guiItems.containsKey(slot)) {
            return;
        }
        GuiItem guiItem = this.guiItems.get(slot);
        guiItem.setItemStack(itemStack);
        this.inventory.setItem(slot, guiItem.getItemStack());
    }

    public void updateItem(int row, int col, @NotNull ItemStack itemStack) {
        this.updateItem(this.getSlotFromRowCol(row, col), itemStack);
    }

    public void updateItem(int slot, @NotNull GuiItem item) {
        if (!this.guiItems.containsKey(slot)) {
            return;
        }
        this.guiItems.put(slot, item);
        this.inventory.setItem(slot, item.getItemStack());
    }

    public void updateItem(int row, int col, @NotNull GuiItem item) {
        this.updateItem(this.getSlotFromRowCol(row, col), item);
    }

    public BaseGui updateTitle(@NotNull String title) {
        this.title = title;
        this.updating = true;
        this.inventory = Bukkit.createInventory((InventoryHolder)this, (int)this.inventory.getSize(), (String)this.title);
        for (HumanEntity player : new ArrayList(this.inventory.getViewers())) {
            this.open(player);
        }
        this.updating = false;
        return this;
    }

    public GuiFiller getFiller() {
        return this.filler;
    }

    public Map<Integer, GuiItem> getGuiItems() {
        return this.guiItems;
    }

    @NotNull
    public Inventory getInventory() {
        return this.inventory;
    }

    public int getRows() {
        return this.rows;
    }

    GuiAction<InventoryClickEvent> getDefaultClickAction() {
        return this.defaultClickAction;
    }

    GuiAction<InventoryClickEvent> getDefaultTopClickAction() {
        return this.defaultTopClickAction;
    }

    GuiAction<InventoryDragEvent> getDragAction() {
        return this.dragAction;
    }

    GuiAction<InventoryCloseEvent> getCloseGuiAction() {
        return this.closeGuiAction;
    }

    GuiAction<InventoryOpenEvent> getOpenGuiAction() {
        return this.openGuiAction;
    }

    GuiAction<InventoryClickEvent> getOutsideClickAction() {
        return this.outsideClickAction;
    }

    GuiAction<InventoryClickEvent> getSlotAction(int slot) {
        return this.isValidSlot(slot) ? this.slotActions.get(slot) : null;
    }

    void populateGui() {
        for (Map.Entry<Integer, GuiItem> entry : this.getGuiItems().entrySet()) {
            this.getInventory().setItem(entry.getKey().intValue(), entry.getValue().getItemStack());
        }
    }

    private boolean isValidSlot(int slot) {
        return slot >= 0 && slot < this.rows * 9;
    }

    int getSlotFromRowCol(int row, int col) {
        return col + (row - 1) * 9 - 1;
    }
}

