/*
 * Decompiled with CFR 0.152.
 */
package me.mattstudios.mfgui.gui.guis;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import me.mattstudios.mfgui.gui.guis.BaseGui;
import me.mattstudios.mfgui.gui.guis.GuiItem;
import org.bukkit.entity.HumanEntity;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public final class PaginatedGui
extends BaseGui {
    private final List<GuiItem> pageItems = new ArrayList<GuiItem>();
    private int pageSize;
    private int page = 1;

    public PaginatedGui(@NotNull Plugin plugin, int rows, int pageSize, @NotNull String title) {
        super(plugin, rows, title);
        this.pageSize = pageSize;
        if (rows < 2) {
            this.setRows(2);
        }
    }

    public PaginatedGui(@NotNull Plugin plugin, @NotNull String title) {
        this(plugin, 2, 9, title);
    }

    public BaseGui addItem(@NotNull GuiItem item) {
        this.pageItems.add(item);
        return this;
    }

    @Override
    public BaseGui addItem(GuiItem ... items) {
        this.pageItems.addAll(Arrays.asList(items));
        return this;
    }

    @Override
    public void update() {
        this.setUpdating(true);
        for (HumanEntity player : this.getInventory().getViewers()) {
            this.open(player);
        }
        this.setUpdating(false);
    }

    @Override
    public void open(@NotNull HumanEntity player) {
        this.getInventory().clear();
        block0: for (GuiItem guiItem : this.getPage(this.page)) {
            for (int slot = 0; slot < this.getRows() * 9; ++slot) {
                if (this.getGuiItem(slot) != null) continue;
                this.setItem(slot, guiItem);
                continue block0;
            }
        }
        for (Map.Entry entry : this.getGuiItems().entrySet()) {
            this.getInventory().setItem(((Integer)entry.getKey()).intValue(), ((GuiItem)entry.getValue()).getItemStack());
        }
        player.openInventory(this.getInventory());
    }

    public int getCurrentPageNum() {
        return this.page;
    }

    public int getNextPageNum() {
        if (this.page + 1 > this.getPagesNum()) {
            return -1;
        }
        return this.page + 1;
    }

    public int getPrevPageNum() {
        if (this.page - 1 == 0) {
            return -1;
        }
        return this.page - 1;
    }

    public void nextPage() {
        if (this.page + 1 > this.getPagesNum()) {
            return;
        }
        ++this.page;
        this.update();
    }

    public void prevPage() {
        if (this.page - 1 == 0) {
            return;
        }
        --this.page;
        this.update();
    }

    private List<GuiItem> getPage(int givenPage) {
        int page = givenPage - 1;
        ArrayList<GuiItem> guiPage = new ArrayList<GuiItem>();
        int max = page * this.pageSize + this.pageSize;
        if (max > this.pageItems.size()) {
            max = this.pageItems.size();
        }
        for (int i = page * this.pageSize; max > i; ++i) {
            guiPage.add(this.pageItems.get(i));
        }
        return guiPage;
    }

    private int getPagesNum() {
        return (int)Math.ceil((double)this.pageItems.size() / (double)this.pageSize);
    }
}

