/*
 * Decompiled with CFR 0.152.
 */
package me.mattstudios.mfgui.gui.guis;

import me.mattstudios.mfgui.gui.components.GuiAction;
import me.mattstudios.mfgui.gui.components.ItemNBT;
import me.mattstudios.mfgui.gui.guis.BaseGui;
import me.mattstudios.mfgui.gui.guis.GuiItem;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.plugin.Plugin;

public final class GuiListener
implements Listener {
    private final Plugin plugin;

    public GuiListener(Plugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler(ignoreCancelled=true)
    public void onGuiCLick(InventoryClickEvent event) {
        GuiItem guiItem;
        GuiAction<InventoryClickEvent> slotAction;
        GuiAction<InventoryClickEvent> defaultClick;
        if (event.getClickedInventory() == null) {
            return;
        }
        if (!(event.getInventory().getHolder() instanceof BaseGui)) {
            return;
        }
        BaseGui gui = (BaseGui)event.getInventory().getHolder();
        GuiAction<InventoryClickEvent> defaultTopClick = gui.getDefaultTopClickAction();
        if (defaultTopClick != null && event.getClickedInventory().getType() != InventoryType.PLAYER) {
            defaultTopClick.execute(event);
        }
        if ((defaultClick = gui.getDefaultClickAction()) != null) {
            defaultClick.execute(event);
        }
        if ((slotAction = gui.getSlotAction(event.getSlot())) != null && event.getClickedInventory().getType() != InventoryType.PLAYER) {
            slotAction.execute(event);
        }
        if ((guiItem = gui.getGuiItem(event.getSlot())) == null) {
            return;
        }
        if (!ItemNBT.getNBTTag(event.getCurrentItem(), "mf-gui").equalsIgnoreCase(guiItem.getUuid().toString())) {
            return;
        }
        guiItem.getAction().execute(event);
    }

    @EventHandler(ignoreCancelled=true)
    public void onGuiDrag(InventoryDragEvent event) {
        if (!(event.getInventory().getHolder() instanceof BaseGui)) {
            return;
        }
        BaseGui gui = (BaseGui)event.getInventory().getHolder();
        GuiAction<InventoryDragEvent> dragAction = gui.getDragAction();
        if (dragAction != null) {
            dragAction.execute(event);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onGuiClose(InventoryCloseEvent event) {
        if (!(event.getInventory().getHolder() instanceof BaseGui)) {
            return;
        }
        BaseGui gui = (BaseGui)event.getInventory().getHolder();
        GuiAction<InventoryCloseEvent> closeAction = gui.getCloseGuiAction();
        if (closeAction != null && !gui.isUpdating()) {
            closeAction.execute(event);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onGuiOpen(InventoryOpenEvent event) {
        if (!(event.getInventory().getHolder() instanceof BaseGui)) {
            return;
        }
        BaseGui gui = (BaseGui)event.getInventory().getHolder();
        GuiAction<InventoryOpenEvent> openAction = gui.getOpenGuiAction();
        if (openAction != null && !gui.isUpdating()) {
            openAction.execute(event);
        }
    }
}

