/*
 * Decompiled with CFR 0.152.
 */
package me.mattstudios.mfgui.gui.guis;

import com.google.common.annotations.Beta;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.mattstudios.mfgui.gui.components.GuiAction;
import me.mattstudios.mfgui.gui.components.GuiException;
import me.mattstudios.mfgui.gui.guis.GuiItem;
import me.mattstudios.mfgui.gui.guis.GuiListener;
import org.bukkit.Bukkit;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import org.jetbrains.annotations.NotNull;

public abstract class BaseGui
implements InventoryHolder {
    private final Plugin plugin;
    private Inventory inventory;
    private String title;
    private int rows;
    private final Map<Integer, GuiItem> guiItems = new HashMap<Integer, GuiItem>();
    private final Map<Integer, GuiAction<InventoryClickEvent>> slotActions = new HashMap<Integer, GuiAction<InventoryClickEvent>>();
    private GuiAction<InventoryClickEvent> defaultClickAction;
    private GuiAction<InventoryClickEvent> defaultTopClickAction;
    private GuiAction<InventoryDragEvent> dragAction;
    private GuiAction<InventoryCloseEvent> closeGuiAction;
    private GuiAction<InventoryOpenEvent> openGuiAction;
    private static boolean registeredListener;
    private boolean updating;
    private boolean autoUpdate = false;
    private BukkitTask id;

    public BaseGui(@NotNull Plugin plugin, int rows, @NotNull String title) {
        int finalRows = rows;
        if (rows < 1 || rows > 6) {
            finalRows = 1;
        }
        this.plugin = plugin;
        this.rows = finalRows;
        this.title = title;
        this.inventory = Bukkit.createInventory((InventoryHolder)this, (int)(this.rows * 9), (String)title);
        if (!registeredListener) {
            Bukkit.getPluginManager().registerEvents((Listener)new GuiListener(plugin), plugin);
            registeredListener = true;
        }
    }

    public BaseGui(@NotNull Plugin plugin, @NotNull String title) {
        this(plugin, 1, title);
    }

    public BaseGui setAutoUpdating(boolean autoUpdate, int intervalTicks) {
        this.autoUpdate = autoUpdate;
        if (!autoUpdate || this.id != null && !this.id.isCancelled()) {
            return this;
        }
        this.id = Bukkit.getScheduler().runTaskTimerAsynchronously(this.plugin, () -> {
            if (!this.autoUpdate) {
                this.id.cancel();
                return;
            }
            if (!this.isUpdating()) {
                this.update();
            }
        }, 0L, (long)intervalTicks);
        return this;
    }

    public BaseGui setRows(int rows) {
        int finalRows = rows;
        if (rows < 1 || rows > 6) {
            finalRows = 1;
        }
        this.rows = finalRows;
        this.updating = true;
        ArrayList viewers = new ArrayList(this.inventory.getViewers());
        this.inventory = Bukkit.createInventory((InventoryHolder)this, (int)(this.rows * 9), (String)this.title);
        for (HumanEntity player : viewers) {
            this.open(player);
        }
        this.updating = false;
        return this;
    }

    public BaseGui setItem(int slot, @NotNull GuiItem guiItem) {
        if (!this.isValidSlot(slot)) {
            throw new GuiException("Invalid item slot!");
        }
        this.guiItems.put(slot, guiItem);
        return this;
    }

    public BaseGui setItem(@NotNull List<Integer> slots, @NotNull GuiItem guiItem) {
        for (int slot : slots) {
            this.setItem(slot, guiItem);
        }
        return this;
    }

    public BaseGui setItem(int row, int col, @NotNull GuiItem guiItem) {
        return this.setItem(this.getSlotFromRowCol(row, col), guiItem);
    }

    public BaseGui fillTop(@NotNull GuiItem guiItem) {
        return this.fillTop(Collections.singletonList(guiItem));
    }

    public BaseGui fillTop(@NotNull List<GuiItem> guiItems) {
        List<GuiItem> items = this.repeatList(guiItems, this.rows * 9);
        for (int i = 0; i < 9; ++i) {
            if (this.guiItems.containsKey(i)) continue;
            this.setItem(i, items.get(i));
        }
        return this;
    }

    public BaseGui fillBottom(@NotNull GuiItem guiItem) {
        return this.fillBottom(Collections.singletonList(guiItem));
    }

    public BaseGui fillBottom(@NotNull List<GuiItem> guiItems) {
        List<GuiItem> items = this.repeatList(guiItems, this.rows * 9);
        for (int i = 9; i > 0; --i) {
            if (this.guiItems.containsKey(i)) continue;
            this.setItem(this.rows * 9 - i, items.get(i));
        }
        return this;
    }

    public BaseGui fillBorder(@NotNull GuiItem guiItem) {
        return this.fillBorder(Collections.singletonList(guiItem));
    }

    public BaseGui fillBorder(@NotNull List<GuiItem> guiItems) {
        if (this.rows <= 2) {
            return this;
        }
        List<GuiItem> items = this.repeatList(guiItems, this.rows * 9);
        for (int i = 0; i < this.rows * 9; ++i) {
            if (i > 8 && i < this.rows * 9 - 9 && i != 9 && i != 18 && i != 27 && i != 36 && i != 17 && i != 26 && i != 35 && i != 44) continue;
            this.setItem(i, items.get(i));
        }
        return this;
    }

    public BaseGui fillBetweenPoints(int rowFrom, int colFrom, int rowTo, int colTo, @NotNull GuiItem guiItem) {
        return this.fillBetweenPoints(rowFrom, colFrom, rowTo, colTo, Collections.singletonList(guiItem));
    }

    public BaseGui fillBetweenPoints(int rowFrom, int colFrom, int rowTo, int colTo, @NotNull List<GuiItem> guiItems) {
        int minRow = Math.min(rowFrom, rowTo);
        int maxRow = Math.max(rowFrom, rowTo);
        int minCol = Math.min(colFrom, colTo);
        int maxCol = Math.max(colFrom, colTo);
        List<GuiItem> items = this.repeatList(guiItems, this.rows * 9);
        for (int row = 1; row <= this.rows; ++row) {
            for (int col = 1; col <= 9; ++col) {
                int slot = this.getSlotFromRowCol(row, col);
                if (row < minRow || row > maxRow || col < minCol || col > maxCol) continue;
                this.setItem(slot, items.get(slot));
            }
        }
        return this;
    }

    public BaseGui fill(@NotNull GuiItem guiItem) {
        return this.fill(Collections.singletonList(guiItem));
    }

    public BaseGui fill(@NotNull List<GuiItem> guiItems) {
        List<GuiItem> items = this.repeatList(guiItems, this.rows * 9);
        for (int i = 0; i < this.rows * 9; ++i) {
            if (this.guiItems.containsKey(i)) continue;
            this.setItem(i, items.get(i));
        }
        return this;
    }

    public BaseGui addItem(GuiItem ... items) {
        block0: for (GuiItem guiItem : items) {
            for (int slot = 0; slot < this.rows * 9; ++slot) {
                if (this.guiItems.get(slot) != null) continue;
                this.guiItems.put(slot, guiItem);
                continue block0;
            }
        }
        return this;
    }

    public BaseGui setDefaultClickAction(GuiAction<InventoryClickEvent> defaultClickAction) {
        this.defaultClickAction = defaultClickAction;
        return this;
    }

    public BaseGui setDefaultTopClickAction(GuiAction<InventoryClickEvent> defaultTopClickAction) {
        this.defaultTopClickAction = defaultTopClickAction;
        return this;
    }

    public BaseGui setDragAction(GuiAction<InventoryDragEvent> dragAction) {
        this.dragAction = dragAction;
        return this;
    }

    public BaseGui setCloseGuiAction(GuiAction<InventoryCloseEvent> closeGuiAction) {
        this.closeGuiAction = closeGuiAction;
        return this;
    }

    public BaseGui setOpenGuiAction(GuiAction<InventoryOpenEvent> openGuiAction) {
        this.openGuiAction = openGuiAction;
        return this;
    }

    public BaseGui addSlotAction(int slot, GuiAction<InventoryClickEvent> slotAction) {
        if (!this.isValidSlot(slot)) {
            return this;
        }
        this.slotActions.put(slot, slotAction);
        return this;
    }

    public BaseGui addSlotAction(int row, int col, GuiAction<InventoryClickEvent> slotAction) {
        return this.addSlotAction(this.getSlotFromRowCol(row, col), slotAction);
    }

    public GuiItem getGuiItem(int slot) {
        return this.isValidSlot(slot) ? this.guiItems.get(slot) : null;
    }

    public boolean isUpdating() {
        return this.updating;
    }

    public void setUpdating(boolean updating) {
        this.updating = updating;
    }

    public void open(@NotNull HumanEntity player) {
        this.inventory.clear();
        for (Map.Entry<Integer, GuiItem> entry : this.getGuiItems().entrySet()) {
            this.inventory.setItem(entry.getKey().intValue(), entry.getValue().getItemStack());
        }
        player.openInventory(this.inventory);
    }

    public void close(@NotNull Player player) {
        Bukkit.getScheduler().runTaskLater(this.plugin, () -> ((Player)player).closeInventory(), 2L);
    }

    public void update() {
        this.updating = true;
        for (HumanEntity player : this.inventory.getViewers()) {
            this.open(player);
        }
        this.updating = false;
    }

    public void updateItem(int slot, @NotNull ItemStack itemStack) {
        if (!this.guiItems.containsKey(slot)) {
            return;
        }
        this.guiItems.get(slot).setItemStack(itemStack);
        this.inventory.setItem(slot, this.guiItems.get(slot).getItemStack());
    }

    public void updateItem(int row, int col, @NotNull ItemStack itemStack) {
        this.updateItem(this.getSlotFromRowCol(row, col), itemStack);
    }

    @Beta
    public void updateTitle(@NotNull String title) {
        this.title = title;
        this.updating = true;
        ArrayList viewers = new ArrayList(this.inventory.getViewers());
        this.inventory = Bukkit.createInventory((InventoryHolder)this, (int)this.inventory.getSize(), (String)this.title);
        for (HumanEntity player : viewers) {
            this.open(player);
        }
        this.updating = false;
    }

    public Map<Integer, GuiItem> getGuiItems() {
        return this.guiItems;
    }

    @NotNull
    public Inventory getInventory() {
        return this.inventory;
    }

    public int getRows() {
        return this.rows;
    }

    GuiAction<InventoryClickEvent> getDefaultClickAction() {
        return this.defaultClickAction;
    }

    GuiAction<InventoryClickEvent> getDefaultTopClickAction() {
        return this.defaultTopClickAction;
    }

    GuiAction<InventoryDragEvent> getDragAction() {
        return this.dragAction;
    }

    GuiAction<InventoryCloseEvent> getCloseGuiAction() {
        return this.closeGuiAction;
    }

    GuiAction<InventoryOpenEvent> getOpenGuiAction() {
        return this.openGuiAction;
    }

    GuiAction<InventoryClickEvent> getSlotAction(int slot) {
        return this.isValidSlot(slot) ? this.slotActions.get(slot) : null;
    }

    private boolean isValidSlot(int slot) {
        return slot >= 0 && slot < this.rows * 9;
    }

    private int getSlotFromRowCol(int row, int col) {
        return col + (row - 1) * 9 - 1;
    }

    private List<GuiItem> repeatList(@NotNull List<GuiItem> guiItems, int newLength) {
        ArrayList<GuiItem> repeated = new ArrayList<GuiItem>();
        Collections.nCopies(this.rows * 9, guiItems).forEach(repeated::addAll);
        return repeated;
    }
}

