/*
 * Decompiled with CFR 0.152.
 */
package me.mattstudios.mfgui.gui.components;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import me.mattstudios.mfgui.gui.components.XMaterial;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.jetbrains.annotations.NotNull;

public final class ItemBuilder {
    private final ItemStack itemStack;
    private ItemMeta meta;

    public ItemBuilder(ItemStack itemStack) {
        Validate.notNull((Object)itemStack, (String)"Item can't be null!");
        this.itemStack = itemStack;
        this.meta = itemStack.hasItemMeta() ? itemStack.getItemMeta() : Bukkit.getItemFactory().getItemMeta(itemStack.getType());
    }

    public ItemBuilder(Material material) {
        this(new ItemStack(material));
    }

    public ItemStack build() {
        this.itemStack.setItemMeta(this.meta);
        return this.itemStack;
    }

    public ItemBuilder setName(@NotNull String name) {
        this.meta.setDisplayName(name);
        return this;
    }

    public ItemBuilder setAmount(int amount) {
        this.itemStack.setAmount(amount);
        return this;
    }

    public ItemBuilder setLore(String ... lore) {
        this.meta.setLore(Arrays.asList(lore));
        return this;
    }

    public ItemBuilder setLore(@NotNull List<String> lore) {
        this.meta.setLore(lore);
        return this;
    }

    public ItemBuilder addEnchantment(@NotNull Enchantment enchantment, int level, boolean ignoreLevelRestriction) {
        this.meta.addEnchant(enchantment, level, ignoreLevelRestriction);
        return this;
    }

    public ItemBuilder addEnchantment(@NotNull Enchantment enchantment, int level) {
        return this.addEnchantment(enchantment, level, true);
    }

    public ItemBuilder addEnchantment(@NotNull Enchantment enchantment) {
        return this.addEnchantment(enchantment, 1, true);
    }

    public ItemBuilder removeEnchantment(@NotNull Enchantment enchantment) {
        this.itemStack.removeEnchantment(enchantment);
        return this;
    }

    public ItemBuilder addItemFlags(ItemFlag ... flags) {
        this.meta.addItemFlags(flags);
        return this;
    }

    public ItemBuilder setUnbreakable(boolean unbreakable) {
        this.meta.setUnbreakable(unbreakable);
        return this;
    }

    public ItemBuilder glow() {
        this.meta.addEnchant(Enchantment.LURE, 1, false);
        this.meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        return this;
    }

    public ItemBuilder setSkullTexture(@NotNull String texture) {
        if (this.itemStack.getType() != XMaterial.PLAYER_HEAD.parseMaterial()) {
            return this;
        }
        SkullMeta skullMeta = (SkullMeta)this.meta;
        GameProfile profile = new GameProfile(UUID.randomUUID(), null);
        profile.getProperties().put((Object)"textures", (Object)new Property("textures", texture));
        try {
            Field profileField = skullMeta.getClass().getDeclaredField("profile");
            profileField.setAccessible(true);
            profileField.set(skullMeta, profile);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException ex) {
            ex.printStackTrace();
        }
        this.meta = skullMeta;
        return this;
    }

    public ItemBuilder setSkullOwner(@NotNull OfflinePlayer player) {
        if (this.itemStack.getType() != XMaterial.PLAYER_HEAD.parseMaterial()) {
            return this;
        }
        SkullMeta skullMeta = (SkullMeta)this.meta;
        skullMeta.setOwningPlayer(player);
        this.meta = skullMeta;
        return this;
    }
}

