/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.paper.common.sampler;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import me.lucko.spark.paper.common.SparkPlatform;
import me.lucko.spark.paper.common.command.sender.CommandSender;
import me.lucko.spark.paper.common.sampler.SamplerMode;
import me.lucko.spark.paper.common.sampler.SamplerType;
import me.lucko.spark.paper.common.sampler.java.MergeStrategy;
import me.lucko.spark.paper.common.sampler.source.ClassSourceLookup;
import me.lucko.spark.paper.common.ws.ViewerSocket;
import me.lucko.spark.paper.proto.SparkProtos;
import me.lucko.spark.paper.proto.SparkSamplerProtos;

public interface Sampler {
    public void start();

    public void stop(boolean var1);

    public void attachSocket(ViewerSocket var1);

    public Collection<ViewerSocket> getAttachedSockets();

    public long getStartTime();

    public long getAutoEndTime();

    public boolean isRunningInBackground();

    public SamplerType getType();

    public String getLibraryVersion();

    public SamplerMode getMode();

    public CompletableFuture<Sampler> getFuture();

    public Map<Integer, SparkProtos.WindowStatistics> exportWindowStatistics();

    public SparkSamplerProtos.SamplerData toProto(SparkPlatform var1, ExportProps var2);

    public static final class ExportProps {
        private CommandSender.Data creator;
        private String comment;
        private MergeStrategy mergeStrategy;
        private Supplier<ClassSourceLookup> classSourceLookup;
        private SparkSamplerProtos.SocketChannelInfo channelInfo;

        public CommandSender.Data creator() {
            return this.creator;
        }

        public String comment() {
            return this.comment;
        }

        public MergeStrategy mergeStrategy() {
            return this.mergeStrategy;
        }

        public Supplier<ClassSourceLookup> classSourceLookup() {
            return this.classSourceLookup;
        }

        public SparkSamplerProtos.SocketChannelInfo channelInfo() {
            return this.channelInfo;
        }

        public ExportProps creator(CommandSender.Data creator) {
            this.creator = creator;
            return this;
        }

        public ExportProps comment(String comment) {
            this.comment = comment;
            return this;
        }

        public ExportProps mergeStrategy(MergeStrategy mergeStrategy) {
            this.mergeStrategy = mergeStrategy;
            return this;
        }

        public ExportProps classSourceLookup(Supplier<ClassSourceLookup> classSourceLookup) {
            this.classSourceLookup = classSourceLookup;
            return this;
        }

        public ExportProps channelInfo(SparkSamplerProtos.SocketChannelInfo channelInfo) {
            this.channelInfo = channelInfo;
            return this;
        }
    }
}

