/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.paper.common.command.modules;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import me.lucko.spark.paper.common.activitylog.Activity;
import me.lucko.spark.paper.common.command.Command;
import me.lucko.spark.paper.common.command.CommandModule;
import me.lucko.spark.paper.common.command.CommandResponseHandler;
import me.lucko.spark.paper.common.command.tabcomplete.TabCompleter;
import me.lucko.spark.paper.lib.adventure.pagination.Pagination;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentBuilder;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;

public class ActivityLogModule
implements CommandModule,
Pagination.Renderer.RowRenderer<Activity> {
    private final Pagination.Builder pagination = Pagination.builder().width(45).renderer(new Pagination.Renderer(){

        @Override
        public Component renderEmpty() {
            return CommandResponseHandler.applyPrefix((Component)Component.text((String)"There are no entries present in the log."));
        }

        @Override
        public Component renderUnknownPage(int page, int pages) {
            return CommandResponseHandler.applyPrefix((Component)Component.text((String)("Unknown page selected. " + pages + " total pages.")));
        }
    }).resultsPerPage(4);

    @Override
    public Collection<Component> renderRow(Activity activity, int index) {
        ArrayList<Component> reply = new ArrayList<Component>(5);
        reply.add((Component)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((String)">", (TextColor)NamedTextColor.DARK_GRAY, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}))).append((Component)Component.space())).append((Component)Component.text((String)("#" + (index + 1)), (TextColor)NamedTextColor.WHITE))).append((Component)Component.text((String)" - ", (TextColor)NamedTextColor.DARK_GRAY))).append((Component)Component.text((String)activity.getType(), (TextColor)NamedTextColor.YELLOW))).append((Component)Component.text((String)" - ", (TextColor)NamedTextColor.DARK_GRAY))).append((Component)Component.text((String)ActivityLogModule.formatDateDiff(activity.getTime()), (TextColor)NamedTextColor.GRAY))).build());
        reply.add((Component)((TextComponent.Builder)((TextComponent.Builder)Component.text().content("  ").append((Component)Component.text((String)"Created by: ", (TextColor)NamedTextColor.GRAY))).append((Component)Component.text((String)activity.getUser().getName(), (TextColor)NamedTextColor.WHITE))).build());
        TextComponent.Builder valueComponent = (TextComponent.Builder)Component.text().content(activity.getDataValue()).color((TextColor)NamedTextColor.WHITE);
        if (activity.getDataType().equals("url")) {
            valueComponent.clickEvent(ClickEvent.openUrl((String)activity.getDataValue()));
        }
        reply.add((Component)((TextComponent.Builder)((TextComponent.Builder)Component.text().content("  ").append((Component)Component.text((String)(Character.toUpperCase(activity.getDataType().charAt(0)) + activity.getDataType().substring(1) + ": "), (TextColor)NamedTextColor.GRAY))).append((ComponentBuilder)valueComponent)).build());
        reply.add((Component)Component.space());
        return reply;
    }

    @Override
    public void registerCommands(Consumer<Command> consumer) {
        consumer.accept(Command.builder().aliases("activity", "activitylog", "log").argumentUsage("page", "page no").executor((platform, sender, resp, arguments) -> {
            List<Activity> log = platform.getActivityLog().getLog();
            log.removeIf(Activity::shouldExpire);
            if (log.isEmpty()) {
                resp.replyPrefixed((Component)Component.text((String)"There are no entries present in the log."));
                return;
            }
            int page = Math.max(1, arguments.intFlag("page"));
            Pagination<Activity> activityPagination = this.pagination.build((Component)Component.text((String)"Recent spark activity", (TextColor)NamedTextColor.GOLD), this, value -> "/" + platform.getPlugin().getCommandName() + " activity --page " + value);
            resp.reply(activityPagination.render(log, page));
        }).tabCompleter((platform, sender, arguments) -> TabCompleter.completeForOpts(arguments, "--page")).build());
    }

    private static String formatDateDiff(long time) {
        long seconds = (System.currentTimeMillis() - time) / 1000L;
        if (seconds <= 0L) {
            return "now";
        }
        long minute = seconds / 60L;
        seconds %= 60L;
        long hour = minute / 60L;
        minute %= 60L;
        long day = hour / 24L;
        hour %= 24L;
        StringBuilder sb = new StringBuilder();
        if (day != 0L) {
            sb.append(day).append("d ");
        }
        if (hour != 0L) {
            sb.append(hour).append("h ");
        }
        if (minute != 0L) {
            sb.append(minute).append("m ");
        }
        if (seconds != 0L) {
            sb.append(seconds).append("s");
        }
        return sb.toString().trim() + " ago";
    }
}

