/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.shadow.bukkit;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Optional;
import me.lucko.shadow.Shadow;
import me.lucko.shadow.TargetResolver;
import me.lucko.shadow.bukkit.Mapping;
import me.lucko.shadow.bukkit.PackageVersion;
import org.checkerframework.checker.nullness.qual.NonNull;

@Target(value={ElementType.METHOD})
@Retention(value=RetentionPolicy.RUNTIME)
public @interface ObfuscatedTarget {
    public static final TargetResolver RESOLVER = new TargetResolver(){

        public @NonNull Optional<String> lookupMethod(@NonNull Method shadowMethod, @NonNull Class<? extends Shadow> shadowClass, @NonNull Class<?> targetClass) {
            return Optional.ofNullable(shadowMethod.getAnnotation(ObfuscatedTarget.class)).flatMap(annotation -> Arrays.stream(annotation.value()).filter(mapping -> PackageVersion.runtimeVersion() == mapping.version()).findFirst()).map(Mapping::value);
        }

        public @NonNull Optional<String> lookupField(@NonNull Method shadowMethod, @NonNull Class<? extends Shadow> shadowClass, @NonNull Class<?> targetClass) {
            return Optional.ofNullable(shadowMethod.getAnnotation(ObfuscatedTarget.class)).flatMap(annotation -> Arrays.stream(annotation.value()).filter(mapping -> PackageVersion.runtimeVersion() == mapping.version()).findFirst()).map(Mapping::value);
        }
    };

    public Mapping[] value();
}

