/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.scriptcontroller.internal;

import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import me.lucko.scriptcontroller.ScriptController;
import me.lucko.scriptcontroller.closable.CompositeAutoClosable;
import me.lucko.scriptcontroller.environment.ScriptEnvironment;
import me.lucko.scriptcontroller.environment.settings.EnvironmentSettings;
import me.lucko.scriptcontroller.internal.EnvironmentSettingsImpl;
import me.lucko.scriptcontroller.internal.FallbackSystemLogger;
import me.lucko.scriptcontroller.internal.ScriptEnvironmentImpl;
import me.lucko.scriptcontroller.logging.SystemLogger;

public final class ScriptControllerImpl
implements ScriptController {
    private final Map<Path, ScriptEnvironment> environments = new HashMap<Path, ScriptEnvironment>();
    private final SystemLogger logger;
    private final EnvironmentSettings defaultSettings;

    @Deprecated
    public static ScriptController.Builder builder() {
        return new Builder();
    }

    @Deprecated
    public static EnvironmentSettings defaultSettings() {
        return EnvironmentSettingsImpl.defaults();
    }

    @Deprecated
    public static EnvironmentSettings.Builder newSettingsBuilder() {
        return EnvironmentSettingsImpl.builder();
    }

    private ScriptControllerImpl(Builder builder) {
        this.logger = (SystemLogger)builder.logger.get();
        this.defaultSettings = builder.settings;
        for (Path path : builder.directories) {
            this.setupNewEnvironment(path);
        }
    }

    @Override
    public Collection<ScriptEnvironment> getEnvironments() {
        return Collections.unmodifiableCollection(this.environments.values());
    }

    @Override
    public synchronized ScriptEnvironment setupNewEnvironment(Path loadDirectory, EnvironmentSettings settings) {
        if (this.environments.containsKey(loadDirectory)) {
            throw new IllegalStateException("Already an environment setup at path " + loadDirectory.toString());
        }
        EnvironmentSettings mergedSettings = this.defaultSettings.toBuilder().mergeSettingsFrom(settings).build();
        ScriptEnvironmentImpl environment = new ScriptEnvironmentImpl(this, loadDirectory, (EnvironmentSettingsImpl)mergedSettings);
        this.environments.put(loadDirectory, environment);
        return environment;
    }

    @Override
    public void shutdown() {
        CompositeAutoClosable.create().bindAll(this.environments.values()).closeAndReportExceptions();
    }

    SystemLogger getLogger() {
        return this.logger;
    }

    private static final class Builder
    implements ScriptController.Builder {
        private final Set<Path> directories = new HashSet<Path>();
        private Supplier<SystemLogger> logger = FallbackSystemLogger.INSTANCE;
        private EnvironmentSettings settings = EnvironmentSettings.defaults();

        private Builder() {
        }

        @Override
        public Builder withDirectory(Path loadDirectory) {
            this.directories.add(Objects.requireNonNull(loadDirectory, "loadDirectory"));
            return this;
        }

        @Override
        public Builder logger(SystemLogger logger) {
            Objects.requireNonNull(logger, "logger");
            this.logger = () -> logger;
            return this;
        }

        @Override
        public Builder defaultEnvironmentSettings(EnvironmentSettings settings) {
            this.settings = Objects.requireNonNull(settings, "settings");
            return this;
        }

        @Override
        public ScriptController build() {
            return new ScriptControllerImpl(this);
        }
    }
}

