/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.scriptcontroller.exports;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import me.lucko.scriptcontroller.exports.Export;
import me.lucko.scriptcontroller.exports.ExportImpl;
import me.lucko.scriptcontroller.exports.ExportRegistry;

final class ExportRegistryImpl
implements ExportRegistry,
Function<String, Export<?>> {
    private final Map<String, Export<?>> exports = new ConcurrentHashMap();

    ExportRegistryImpl() {
    }

    @Override
    public Export<?> apply(String s) {
        return new ExportImpl(s);
    }

    @Override
    public <T> Export<T> get(String name) {
        return this.exports.computeIfAbsent(name.toLowerCase(), this);
    }

    @Override
    public void remove(String name) {
        Export<?> export = this.exports.get(name.toLowerCase());
        if (export != null) {
            export.clear();
        }
    }

    @Override
    public Collection<Export<?>> getAll() {
        return Collections.unmodifiableCollection(this.exports.values());
    }
}

