/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.scriptcontroller.environment.loader;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import me.lucko.scriptcontroller.environment.ScriptEnvironment;
import me.lucko.scriptcontroller.environment.loader.ScriptLoader;

public class DelegateScriptLoader
implements ScriptLoader {
    private ScriptLoader parent;
    private Set<String> paths = new HashSet<String>();

    public DelegateScriptLoader(ScriptLoader parent) {
        this.parent = parent;
    }

    @Override
    public ScriptEnvironment getEnvironment() {
        return this.parent.getEnvironment();
    }

    @Override
    public void watchAll(Collection<String> paths) {
        for (String s : paths) {
            if (this.paths.contains(s)) continue;
            this.paths.add(s);
            this.parent.watch(s);
        }
    }

    @Override
    public void unwatchAll(Collection<String> paths) {
        for (String s : paths) {
            if (!this.paths.contains(s)) continue;
            this.paths.remove(s);
            this.parent.unwatch(s);
        }
    }

    @Override
    public void close() {
        this.parent.unwatchAll(this.paths);
        this.paths.clear();
    }
}

