/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.api.context;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.SetMultimap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterator;
import me.lucko.luckperms.api.context.AbstractContextSet;
import me.lucko.luckperms.api.context.ContextSet;
import me.lucko.luckperms.api.context.MutableContextSet;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class ImmutableContextSet
extends AbstractContextSet
implements ContextSet {
    private static final ImmutableContextSet EMPTY = new ImmutableContextSet((ImmutableSetMultimap<String, String>)ImmutableSetMultimap.of());
    private final ImmutableSetMultimap<String, String> map;
    private final int hashCode;

    public static @NonNull Builder builder() {
        return new Builder();
    }

    public static @NonNull ImmutableContextSet singleton(@NonNull String key, @NonNull String value) {
        return new ImmutableContextSet((ImmutableSetMultimap<String, String>)ImmutableSetMultimap.of((Object)ImmutableContextSet.sanitizeKey(key), (Object)ImmutableContextSet.sanitizeValue(value)));
    }

    public static @NonNull ImmutableContextSet of(@NonNull String key1, @NonNull String value1, @NonNull String key2, @NonNull String value2) {
        return new ImmutableContextSet((ImmutableSetMultimap<String, String>)ImmutableSetMultimap.of((Object)ImmutableContextSet.sanitizeKey(key1), (Object)ImmutableContextSet.sanitizeValue(value1), (Object)ImmutableContextSet.sanitizeKey(key2), (Object)ImmutableContextSet.sanitizeValue(value2)));
    }

    public static @NonNull ImmutableContextSet fromEntries(@NonNull Iterable<? extends Map.Entry<String, String>> iterable) {
        Objects.requireNonNull(iterable, "iterable");
        Builder builder = ImmutableContextSet.builder();
        for (Map.Entry<String, String> entry : iterable) {
            builder.add(entry);
        }
        return builder.build();
    }

    public static @NonNull ImmutableContextSet fromMap(@NonNull Map<String, String> map) {
        return ImmutableContextSet.fromEntries(Objects.requireNonNull(map, "map").entrySet());
    }

    public static @NonNull ImmutableContextSet fromMultimap(@NonNull Multimap<String, String> multimap) {
        return ImmutableContextSet.fromEntries(Objects.requireNonNull(multimap, "multimap").entries());
    }

    public static @NonNull ImmutableContextSet fromSet(@NonNull ContextSet contextSet) {
        return Objects.requireNonNull(contextSet, "contextSet").makeImmutable();
    }

    public static @NonNull ImmutableContextSet empty() {
        return EMPTY;
    }

    ImmutableContextSet(ImmutableSetMultimap<String, String> contexts) {
        this.map = contexts;
        this.hashCode = this.map.hashCode();
    }

    @Override
    protected SetMultimap<String, String> backing() {
        return this.map;
    }

    @Override
    protected void copyTo(SetMultimap<String, String> other) {
        other.putAll(this.map);
    }

    @Override
    public boolean isImmutable() {
        return true;
    }

    @Override
    @Deprecated
    public @NonNull ImmutableContextSet makeImmutable() {
        return this;
    }

    @Override
    public @NonNull MutableContextSet mutableCopy() {
        return MutableContextSet.fromSet(this);
    }

    @Override
    public @NonNull Set<Map.Entry<String, String>> toSet() {
        return this.map.entries();
    }

    @Override
    @Deprecated
    public @NonNull Map<String, String> toMap() {
        ImmutableMap.Builder m = ImmutableMap.builder();
        for (Map.Entry e : this.map.entries()) {
            m.put(e.getKey(), e.getValue());
        }
        return m.build();
    }

    @Override
    public @NonNull Multimap<String, String> toMultimap() {
        return this.map;
    }

    @Override
    public @NonNull Iterator<Map.Entry<String, String>> iterator() {
        return this.map.entries().iterator();
    }

    @Override
    public Spliterator<Map.Entry<String, String>> spliterator() {
        return this.map.entries().spliterator();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ContextSet)) {
            return false;
        }
        ContextSet that = (ContextSet)o;
        if (that instanceof ImmutableContextSet) {
            ImmutableContextSet immutableThat = (ImmutableContextSet)that;
            if (this.hashCode != immutableThat.hashCode) {
                return false;
            }
        }
        Object thatBacking = that instanceof AbstractContextSet ? ((AbstractContextSet)that).backing() : that.toMultimap();
        return this.backing().equals(thatBacking);
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return "ImmutableContextSet(contexts=" + this.map + ")";
    }

    public static final class Builder {
        private ImmutableSetMultimap.Builder<String, String> builder;

        private Builder() {
        }

        private synchronized ImmutableSetMultimap.Builder<String, String> builder() {
            if (this.builder == null) {
                this.builder = ImmutableSetMultimap.builder();
            }
            return this.builder;
        }

        private void put(String key, String value) {
            this.builder().put((Object)key, (Object)value);
        }

        public @NonNull Builder add(@NonNull String key, @NonNull String value) {
            this.put(AbstractContextSet.sanitizeKey(key), AbstractContextSet.sanitizeValue(value));
            return this;
        }

        public @NonNull Builder add(@NonNull Map.Entry<String, String> entry) {
            Objects.requireNonNull(entry, "entry");
            this.add(entry.getKey(), entry.getValue());
            return this;
        }

        public @NonNull Builder addAll(@NonNull Iterable<? extends Map.Entry<String, String>> iterable) {
            for (Map.Entry<String, String> entry : Objects.requireNonNull(iterable, "iterable")) {
                this.add(entry);
            }
            return this;
        }

        public @NonNull Builder addAll(@NonNull Map<String, String> map) {
            this.addAll(Objects.requireNonNull(map, "map").entrySet());
            return this;
        }

        public @NonNull Builder addAll(@NonNull Multimap<String, String> multimap) {
            this.addAll(Objects.requireNonNull(multimap, "multimap").entries());
            return this;
        }

        public @NonNull Builder addAll(@NonNull ContextSet contextSet) {
            Objects.requireNonNull(contextSet, "contextSet");
            if (contextSet instanceof AbstractContextSet) {
                AbstractContextSet other = (AbstractContextSet)contextSet;
                if (!other.isEmpty()) {
                    this.builder().putAll(other.backing());
                }
            } else {
                this.addAll(contextSet.toMultimap());
            }
            return this;
        }

        public @NonNull ImmutableContextSet build() {
            if (this.builder == null) {
                return ImmutableContextSet.empty();
            }
            return new ImmutableContextSet((ImmutableSetMultimap<String, String>)this.builder.build());
        }
    }
}

