/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.api;

import com.google.common.base.Preconditions;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import me.lucko.luckperms.api.NodeEqualityPredicate;
import me.lucko.luckperms.api.StandardNodeEquality;
import me.lucko.luckperms.api.Tristate;
import me.lucko.luckperms.api.context.ContextSet;
import me.lucko.luckperms.api.nodetype.NodeType;
import me.lucko.luckperms.api.nodetype.NodeTypeKey;
import me.lucko.luckperms.api.nodetype.types.InheritanceType;
import me.lucko.luckperms.api.nodetype.types.MetaType;
import me.lucko.luckperms.api.nodetype.types.PrefixType;
import me.lucko.luckperms.api.nodetype.types.SuffixType;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface Node {
    public @NonNull String getPermission();

    public boolean getValue();

    default public @NonNull Tristate getTristate() {
        return Tristate.fromBoolean(this.getValue());
    }

    default public boolean isNegated() {
        return !this.getValue();
    }

    public boolean isOverride();

    public @NonNull Optional<String> getServer();

    public @NonNull Optional<String> getWorld();

    public boolean isServerSpecific();

    public boolean isWorldSpecific();

    public boolean appliesGlobally();

    public boolean hasSpecificContext();

    public boolean shouldApplyWithContext(@NonNull ContextSet var1);

    public @NonNull List<String> resolveShorthand();

    public boolean isTemporary();

    default public boolean isPermanent() {
        return !this.isTemporary();
    }

    public long getExpiryUnixTime() throws IllegalStateException;

    public @NonNull Date getExpiry() throws IllegalStateException;

    public long getSecondsTilExpiry() throws IllegalStateException;

    public boolean hasExpired();

    public @NonNull ContextSet getContexts();

    public @NonNull ContextSet getFullContexts();

    public boolean isWildcard();

    public int getWildcardLevel() throws IllegalStateException;

    public boolean hasTypeData();

    public <T extends NodeType> Optional<T> getTypeData(NodeTypeKey<T> var1);

    default public <T extends NodeType> T typeData(NodeTypeKey<T> key) throws IllegalStateException {
        return (T)((NodeType)this.getTypeData(key).orElseThrow(() -> new IllegalStateException("Node '" + this.getPermission() + "' does not have the '" + key.getTypeName() + "' type.")));
    }

    default public boolean isGroupNode() {
        return this.getTypeData(InheritanceType.KEY).isPresent();
    }

    default public @NonNull String getGroupName() throws IllegalStateException {
        return this.typeData(InheritanceType.KEY).getGroupName();
    }

    default public boolean isMeta() {
        return this.getTypeData(MetaType.KEY).isPresent();
    }

    default public @NonNull Map.Entry<String, String> getMeta() throws IllegalStateException {
        return this.typeData(MetaType.KEY);
    }

    default public boolean isPrefix() {
        return this.getTypeData(PrefixType.KEY).isPresent();
    }

    default public @NonNull Map.Entry<Integer, String> getPrefix() throws IllegalStateException {
        return this.typeData(PrefixType.KEY).getAsEntry();
    }

    default public boolean isSuffix() {
        return this.getTypeData(SuffixType.KEY).isPresent();
    }

    default public @NonNull Map.Entry<Integer, String> getSuffix() throws IllegalStateException {
        return this.typeData(SuffixType.KEY).getAsEntry();
    }

    public boolean equals(Object var1);

    public boolean equals(Node var1, NodeEqualityPredicate var2);

    @Deprecated
    default public boolean equalsIgnoringValue(@NonNull Node other) {
        return this.equals(other, StandardNodeEquality.IGNORE_VALUE);
    }

    @Deprecated
    default public boolean almostEquals(@NonNull Node other) {
        return this.equals(other, StandardNodeEquality.IGNORE_EXPIRY_TIME_AND_VALUE);
    }

    @Deprecated
    default public boolean equalsIgnoringValueOrTemp(@NonNull Node other) {
        return this.equals(other, StandardNodeEquality.IGNORE_VALUE_OR_IF_TEMPORARY);
    }

    public Builder toBuilder();

    public static interface Builder {
        public Builder copyFrom(@NonNull Node var1);

        public @NonNull Builder setNegated(boolean var1);

        public @NonNull Builder setValue(boolean var1);

        public @NonNull Builder setOverride(boolean var1);

        public @NonNull Builder setExpiry(long var1);

        default public @NonNull Builder setExpiry(long duration, TimeUnit unit) {
            Preconditions.checkArgument((duration > 0L ? 1 : 0) != 0, (Object)"duration must be positive");
            long seconds = Objects.requireNonNull(unit, "unit").toSeconds(duration);
            long timeNow = System.currentTimeMillis() / 1000L;
            return this.setExpiry(timeNow + seconds);
        }

        public @NonNull Builder clearExpiry();

        public @NonNull Builder setWorld(@Nullable String var1);

        public @NonNull Builder setServer(@Nullable String var1);

        public @NonNull Builder withExtraContext(@NonNull String var1, @NonNull String var2);

        public @NonNull Builder withExtraContext(@NonNull Map<String, String> var1);

        public @NonNull Builder withExtraContext(@NonNull Set<Map.Entry<String, String>> var1);

        public @NonNull Builder withExtraContext(@NonNull Map.Entry<String, String> var1);

        public @NonNull Builder withExtraContext(@NonNull ContextSet var1);

        public @NonNull Builder setExtraContext(@NonNull ContextSet var1);

        public @NonNull Node build();
    }
}

