/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.api;

import java.util.EnumSet;
import java.util.Set;

public enum LookupSetting {
    IS_OP,
    INCLUDE_NODES_SET_WITHOUT_SERVER,
    INCLUDE_NODES_SET_WITHOUT_WORLD,
    RESOLVE_INHERITANCE,
    APPLY_PARENTS_SET_WITHOUT_SERVER,
    APPLY_PARENTS_SET_WITHOUT_WORLD;


    static boolean isSet(byte b, LookupSetting setting) {
        return (b >> setting.ordinal() & 1) == 1;
    }

    static byte createFlag(LookupSetting ... settings) {
        byte b = 0;
        for (LookupSetting setting : settings) {
            b = (byte)(b | 1 << setting.ordinal());
        }
        return b;
    }

    static byte createFlag(Set<LookupSetting> settings) {
        byte b = 0;
        for (LookupSetting setting : settings) {
            b = (byte)(b | 1 << setting.ordinal());
        }
        return b;
    }

    static Set<LookupSetting> createSetFromFlag(byte b) {
        EnumSet<LookupSetting> settings = EnumSet.noneOf(LookupSetting.class);
        for (LookupSetting setting : LookupSetting.values()) {
            if ((b >> setting.ordinal() & 1) != 1) continue;
            settings.add(setting);
        }
        return settings;
    }

    static byte createFlag(boolean includeNodesSetWithoutServer, boolean includeNodesSetWithoutWorld, boolean resolveInheritance, boolean applyParentsWithoutServer, boolean applyParentsWithoutWorld, boolean isOp) {
        byte b = 0;
        if (includeNodesSetWithoutServer) {
            b = (byte)(b | 1 << INCLUDE_NODES_SET_WITHOUT_SERVER.ordinal());
        }
        if (includeNodesSetWithoutWorld) {
            b = (byte)(b | 1 << INCLUDE_NODES_SET_WITHOUT_WORLD.ordinal());
        }
        if (resolveInheritance) {
            b = (byte)(b | 1 << RESOLVE_INHERITANCE.ordinal());
        }
        if (applyParentsWithoutServer) {
            b = (byte)(b | 1 << APPLY_PARENTS_SET_WITHOUT_SERVER.ordinal());
        }
        if (applyParentsWithoutWorld) {
            b = (byte)(b | 1 << APPLY_PARENTS_SET_WITHOUT_WORLD.ordinal());
        }
        if (isOp) {
            b = (byte)(b | 1 << IS_OP.ordinal());
        }
        return b;
    }
}

