/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.api;

import java.util.Objects;
import java.util.Optional;
import me.lucko.luckperms.api.Node;
import org.checkerframework.checker.nullness.qual.NonNull;

public enum ChatMetaType {
    PREFIX("prefix"){

        @Override
        public boolean matches(@NonNull Node node) {
            return Objects.requireNonNull(node, "node").isPrefix();
        }

        @Override
        public  @NonNull Map.Entry<Integer, String> getEntry(@NonNull Node node) {
            return Objects.requireNonNull(node, "node").getPrefix();
        }
    }
    ,
    SUFFIX("suffix"){

        @Override
        public boolean matches(@NonNull Node node) {
            return Objects.requireNonNull(node, "node").isSuffix();
        }

        @Override
        public  @NonNull Map.Entry<Integer, String> getEntry(@NonNull Node node) {
            return Objects.requireNonNull(node, "node").getSuffix();
        }
    };

    private final String str;

    private ChatMetaType(String str) {
        this.str = str;
    }

    public abstract boolean matches(@NonNull Node var1);

    public boolean shouldIgnore(@NonNull Node node) {
        return !this.matches(node);
    }

    public abstract  @NonNull Map.Entry<Integer, String> getEntry(@NonNull Node var1);

    public String toString() {
        return this.str;
    }

    public static @NonNull Optional<ChatMetaType> ofNode(@NonNull Node node) {
        if (node.isPrefix()) {
            return Optional.of(PREFIX);
        }
        if (node.isSuffix()) {
            return Optional.of(SUFFIX);
        }
        return Optional.empty();
    }
}

