/*
 * This file is part of LuckPerms, licensed under the MIT License.
 *
 *  Copyright (c) lucko (Luck) <luck@lucko.me>
 *  Copyright (c) contributors
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a copy
 *  of this software and associated documentation files (the "Software"), to deal
 *  in the Software without restriction, including without limitation the rights
 *  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 *  copies of the Software, and to permit persons to whom the Software is
 *  furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in all
 *  copies or substantial portions of the Software.
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 *  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 *  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 *  SOFTWARE.
 */

package me.lucko.luckperms.api.event.user;

import me.lucko.luckperms.api.User;
import me.lucko.luckperms.api.event.LuckPermsEvent;
import me.lucko.luckperms.api.event.Param;

import org.checkerframework.checker.nullness.qual.NonNull;

import java.util.UUID;

/**
 * Called when LuckPerms has finished processing a certain Player's connection.
 *
 * <p>This event will always execute during the platforms async login/auth event.
 * All handlers will be called instantly.</p>
 *
 * <p>This, among other things, allows you to wait until permission data is loaded
 * for a User during the BungeeCord 'LoginEvent', as event priorities are ignored
 * by the current implementation.</p>
 *
 * @since 3.4
 */
public interface UserLoginProcessEvent extends LuckPermsEvent {

    /**
     * Gets the UUID of the connection which was processed
     *
     * @return the uuid of the connection which was processed
     */
    @NonNull @Param(0) UUID getUuid();

    /**
     * Gets the username of the connection which was processed
     *
     * @return the username of the connection which was processed
     */
    @NonNull @Param(1) String getUsername();

    /**
     * Gets the resultant User instance which was loaded.
     *
     * @return the user instance
     */
    @NonNull @Param(2) User getUser();

}
