/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.api;

import com.google.common.collect.ImmutableSetMultimap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import me.lucko.luckperms.api.Contexts;
import me.lucko.luckperms.api.DataMutateResult;
import me.lucko.luckperms.api.Group;
import me.lucko.luckperms.api.LocalizedNode;
import me.lucko.luckperms.api.Node;
import me.lucko.luckperms.api.NodeEqualityPredicate;
import me.lucko.luckperms.api.Tristate;
import me.lucko.luckperms.api.caching.CachedData;
import me.lucko.luckperms.api.context.ContextSet;
import me.lucko.luckperms.api.context.ImmutableContextSet;

public interface PermissionHolder {
    @Nonnull
    public String getObjectName();

    @Nonnull
    public String getFriendlyName();

    @Nonnull
    public CachedData getCachedData();

    @Nonnull
    public CompletableFuture<Void> refreshCachedData();

    @Nonnull
    public ImmutableSetMultimap<ImmutableContextSet, Node> getNodes();

    @Nonnull
    public ImmutableSetMultimap<ImmutableContextSet, Node> getTransientNodes();

    @Nonnull
    public List<Node> getOwnNodes();

    @Nonnull
    public SortedSet<? extends Node> getPermissions();

    @Nonnull
    public Set<? extends Node> getEnduringPermissions();

    @Nonnull
    public Set<? extends Node> getTransientPermissions();

    @Nonnull
    public Set<Node> getPermanentPermissionNodes();

    @Nonnull
    public Set<Node> getTemporaryPermissionNodes();

    @Nonnull
    public List<LocalizedNode> resolveInheritances(Contexts var1);

    @Nonnull
    public List<LocalizedNode> resolveInheritances();

    @Nonnull
    public SortedSet<LocalizedNode> getAllNodes(@Nonnull Contexts var1);

    @Nonnull
    public SortedSet<LocalizedNode> getAllNodes();

    @Nonnull
    public Set<LocalizedNode> getAllNodesFiltered(@Nonnull Contexts var1);

    @Nonnull
    public Map<String, Boolean> exportNodes(@Nonnull Contexts var1, boolean var2);

    public void auditTemporaryPermissions();

    @Nonnull
    public Tristate hasPermission(@Nonnull Node var1, @Nonnull NodeEqualityPredicate var2);

    @Nonnull
    public Tristate hasTransientPermission(@Nonnull Node var1, @Nonnull NodeEqualityPredicate var2);

    @Nonnull
    public Tristate inheritsPermission(@Nonnull Node var1, @Nonnull NodeEqualityPredicate var2);

    @Nonnull
    public Tristate hasPermission(@Nonnull Node var1);

    @Nonnull
    public Tristate hasTransientPermission(@Nonnull Node var1);

    @Nonnull
    public Tristate inheritsPermission(@Nonnull Node var1);

    public boolean inheritsGroup(@Nonnull Group var1);

    public boolean inheritsGroup(@Nonnull Group var1, @Nonnull ContextSet var2);

    @Nonnull
    public DataMutateResult setPermission(@Nonnull Node var1);

    @Nonnull
    public DataMutateResult setTransientPermission(@Nonnull Node var1);

    @Nonnull
    public DataMutateResult unsetPermission(@Nonnull Node var1);

    @Nonnull
    public DataMutateResult unsetTransientPermission(@Nonnull Node var1);

    public void clearMatching(@Nonnull Predicate<Node> var1);

    public void clearMatchingTransient(@Nonnull Predicate<Node> var1);

    public void clearNodes();

    public void clearNodes(@Nonnull ContextSet var1);

    public void clearParents();

    public void clearParents(@Nonnull ContextSet var1);

    public void clearMeta();

    public void clearMeta(@Nonnull ContextSet var1);

    public void clearTransientNodes();

    @Nonnull
    @Deprecated
    default public DataMutateResult setPermissionUnchecked(@Nonnull Node node) {
        return this.setPermission(node);
    }

    @Nonnull
    @Deprecated
    default public DataMutateResult setTransientPermissionUnchecked(@Nonnull Node node) {
        return this.setTransientPermission(node);
    }

    @Nonnull
    @Deprecated
    default public DataMutateResult unsetPermissionUnchecked(@Nonnull Node node) {
        return this.unsetPermission(node);
    }

    @Nonnull
    @Deprecated
    default public DataMutateResult unsetTransientPermissionUnchecked(@Nonnull Node node) {
        return this.unsetTransientPermission(node);
    }
}

