/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.api.context;

import com.google.common.collect.Multimap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import me.lucko.luckperms.api.context.ImmutableContextSet;
import me.lucko.luckperms.api.context.MutableContextSet;

public interface ContextSet {
    @Nonnull
    public static ImmutableContextSet singleton(@Nonnull String key, @Nonnull String value) {
        return ImmutableContextSet.singleton(key, value);
    }

    @Nonnull
    public static ImmutableContextSet of(@Nonnull String key1, @Nonnull String value1, @Nonnull String key2, @Nonnull String value2) {
        return ImmutableContextSet.of(key1, value1, key2, value2);
    }

    @Nonnull
    public static ImmutableContextSet fromEntries(@Nonnull Iterable<? extends Map.Entry<String, String>> iterable) {
        return ImmutableContextSet.fromEntries(iterable);
    }

    @Nonnull
    public static ImmutableContextSet fromMap(@Nonnull Map<String, String> map) {
        return ImmutableContextSet.fromMap(map);
    }

    @Nonnull
    public static ImmutableContextSet fromMultimap(@Nonnull Multimap<String, String> multimap) {
        return ImmutableContextSet.fromMultimap(multimap);
    }

    @Nonnull
    public static ImmutableContextSet fromSet(@Nonnull ContextSet contextSet) {
        return ImmutableContextSet.fromSet(contextSet);
    }

    @Nonnull
    public static ImmutableContextSet empty() {
        return ImmutableContextSet.empty();
    }

    public boolean isImmutable();

    @Nonnull
    public ImmutableContextSet makeImmutable();

    @Nonnull
    public MutableContextSet mutableCopy();

    @Nonnull
    public Set<Map.Entry<String, String>> toSet();

    @Nonnull
    @Deprecated
    public Map<String, String> toMap();

    @Nonnull
    public Multimap<String, String> toMultimap();

    public boolean containsKey(@Nonnull String var1);

    @Nonnull
    public Set<String> getValues(@Nonnull String var1);

    @Nonnull
    default public Optional<String> getAnyValue(@Nonnull String key) {
        return this.getValues(key).stream().findAny();
    }

    public boolean has(@Nonnull String var1, @Nonnull String var2);

    public boolean hasIgnoreCase(@Nonnull String var1, @Nonnull String var2);

    default public boolean has(@Nonnull Map.Entry<String, String> entry) {
        Objects.requireNonNull(entry, "entry");
        return this.has(entry.getKey(), entry.getValue());
    }

    default public boolean hasIgnoreCase(@Nonnull Map.Entry<String, String> entry) {
        Objects.requireNonNull(entry, "entry");
        return this.hasIgnoreCase(entry.getKey(), entry.getValue());
    }

    default public boolean isSatisfiedBy(@Nonnull ContextSet other) {
        return this.isSatisfiedBy(other, true);
    }

    default public boolean isSatisfiedBy(@Nonnull ContextSet other, boolean caseSensitive) {
        if (this == other) {
            return true;
        }
        Objects.requireNonNull(other, "other");
        if (this.isEmpty()) {
            return true;
        }
        if (other.isEmpty()) {
            return false;
        }
        if (this.size() > other.size()) {
            return false;
        }
        for (Map.Entry<String, String> context : this.toSet()) {
            if (!(caseSensitive ? !other.has(context) : !other.hasIgnoreCase(context))) continue;
            return false;
        }
        return true;
    }

    public boolean isEmpty();

    public int size();
}

