/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.api;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import me.lucko.luckperms.api.NodeEqualityPredicate;
import me.lucko.luckperms.api.StandardNodeEquality;
import me.lucko.luckperms.api.Tristate;
import me.lucko.luckperms.api.context.ContextSet;

@Immutable
public interface Node {
    @Nonnull
    public String getPermission();

    @Nonnull
    default public Boolean getValue() {
        return this.getValuePrimitive();
    }

    public boolean getValuePrimitive();

    @Nonnull
    default public Tristate getTristate() {
        return Tristate.fromBoolean(this.getValuePrimitive());
    }

    default public boolean isNegated() {
        return !this.getValuePrimitive();
    }

    public boolean isOverride();

    @Nonnull
    public Optional<String> getServer();

    @Nonnull
    public Optional<String> getWorld();

    public boolean isServerSpecific();

    public boolean isWorldSpecific();

    public boolean appliesGlobally();

    public boolean hasSpecificContext();

    public boolean shouldApplyWithContext(@Nonnull ContextSet var1);

    @Nonnull
    public List<String> resolveShorthand();

    public boolean isTemporary();

    default public boolean isPermanent() {
        return !this.isTemporary();
    }

    public long getExpiryUnixTime() throws IllegalStateException;

    @Nonnull
    public Date getExpiry() throws IllegalStateException;

    public long getSecondsTilExpiry() throws IllegalStateException;

    public boolean hasExpired();

    @Nonnull
    public ContextSet getContexts();

    @Nonnull
    public ContextSet getFullContexts();

    public boolean isGroupNode();

    @Nonnull
    public String getGroupName() throws IllegalStateException;

    public boolean isWildcard();

    public int getWildcardLevel() throws IllegalStateException;

    public boolean isMeta();

    @Nonnull
    public Map.Entry<String, String> getMeta() throws IllegalStateException;

    public boolean isPrefix();

    @Nonnull
    public Map.Entry<Integer, String> getPrefix() throws IllegalStateException;

    public boolean isSuffix();

    @Nonnull
    public Map.Entry<Integer, String> getSuffix() throws IllegalStateException;

    public boolean equals(Object var1);

    public boolean standardEquals(Node var1, StandardNodeEquality var2);

    default public boolean equals(Node other, NodeEqualityPredicate equalityPredicate) {
        return equalityPredicate.areEqual(this, other);
    }

    @Deprecated
    default public boolean equalsIgnoringValue(@Nonnull Node other) {
        return this.equals(other, StandardNodeEquality.IGNORE_VALUE);
    }

    @Deprecated
    default public boolean almostEquals(@Nonnull Node other) {
        return this.equals(other, StandardNodeEquality.IGNORE_EXPIRY_TIME_AND_VALUE);
    }

    @Deprecated
    default public boolean equalsIgnoringValueOrTemp(@Nonnull Node other) {
        return this.equals(other, StandardNodeEquality.IGNORE_VALUE_OR_IF_TEMPORARY);
    }

    public Builder toBuilder();

    public static interface Builder {
        @Nonnull
        public Builder setNegated(boolean var1);

        @Nonnull
        public Builder setValue(boolean var1);

        @Nonnull
        public Builder setOverride(boolean var1);

        @Nonnull
        public Builder setExpiry(long var1);

        @Nonnull
        public Builder setWorld(@Nullable String var1);

        @Nonnull
        public Builder setServer(@Nullable String var1);

        @Nonnull
        public Builder withExtraContext(@Nonnull String var1, @Nonnull String var2);

        @Nonnull
        public Builder withExtraContext(@Nonnull Map<String, String> var1);

        @Nonnull
        public Builder withExtraContext(@Nonnull Set<Map.Entry<String, String>> var1);

        @Nonnull
        public Builder withExtraContext(@Nonnull Map.Entry<String, String> var1);

        @Nonnull
        public Builder withExtraContext(@Nonnull ContextSet var1);

        @Nonnull
        public Node build();
    }
}

