/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.api;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import me.lucko.luckperms.api.Tristate;
import me.lucko.luckperms.api.context.ContextSet;

public interface Node
extends Map.Entry<String, Boolean> {
    @Nonnull
    public String getPermission();

    @Override
    @Nonnull
    default public Boolean getValue() {
        return this.getValuePrimitive();
    }

    public boolean getValuePrimitive();

    @Nonnull
    default public Tristate getTristate() {
        return Tristate.fromBoolean(this.getValuePrimitive());
    }

    default public boolean isNegated() {
        return !this.getValuePrimitive();
    }

    public boolean isOverride();

    @Nonnull
    public Optional<String> getServer();

    @Nonnull
    public Optional<String> getWorld();

    public boolean isServerSpecific();

    public boolean isWorldSpecific();

    public boolean appliesGlobally();

    public boolean hasSpecificContext();

    public boolean shouldApplyWithContext(@Nonnull ContextSet var1);

    @Nonnull
    public List<String> resolveShorthand();

    public boolean isTemporary();

    default public boolean isPermanent() {
        return !this.isTemporary();
    }

    public long getExpiryUnixTime() throws IllegalStateException;

    @Nonnull
    public Date getExpiry() throws IllegalStateException;

    public long getSecondsTilExpiry() throws IllegalStateException;

    public boolean hasExpired();

    @Nonnull
    public ContextSet getContexts();

    @Nonnull
    public ContextSet getFullContexts();

    public boolean isGroupNode();

    @Nonnull
    public String getGroupName() throws IllegalStateException;

    public boolean isWildcard();

    public int getWildcardLevel() throws IllegalStateException;

    public boolean isMeta();

    @Nonnull
    public Map.Entry<String, String> getMeta() throws IllegalStateException;

    public boolean isPrefix();

    @Nonnull
    public Map.Entry<Integer, String> getPrefix() throws IllegalStateException;

    public boolean isSuffix();

    @Nonnull
    public Map.Entry<Integer, String> getSuffix() throws IllegalStateException;

    @Override
    public boolean equals(Object var1);

    public boolean equalsIgnoringValue(@Nonnull Node var1);

    public boolean almostEquals(@Nonnull Node var1);

    public boolean equalsIgnoringValueOrTemp(@Nonnull Node var1);

    public static interface Builder {
        @Nonnull
        public Builder setNegated(boolean var1);

        @Nonnull
        public Builder setValue(boolean var1);

        @Nonnull
        public Builder setOverride(boolean var1);

        @Nonnull
        public Builder setExpiry(long var1);

        @Nonnull
        public Builder setWorld(@Nonnull String var1);

        @Nonnull
        public Builder setServer(@Nonnull String var1) throws IllegalArgumentException;

        @Nonnull
        public Builder withExtraContext(@Nonnull String var1, @Nonnull String var2);

        @Nonnull
        public Builder withExtraContext(@Nonnull Map<String, String> var1);

        @Nonnull
        public Builder withExtraContext(@Nonnull Set<Map.Entry<String, String>> var1);

        @Nonnull
        public Builder withExtraContext(@Nonnull Map.Entry<String, String> var1);

        @Nonnull
        public Builder withExtraContext(@Nonnull ContextSet var1);

        @Nonnull
        public Node build();
    }
}

