/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.shadow;

import java.lang.invoke.MethodHandle;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Objects;
import me.lucko.shadow.Field;
import me.lucko.shadow.PrivateMethodHandles;
import me.lucko.shadow.Reflection;
import me.lucko.shadow.Shadow;
import me.lucko.shadow.ShadowDefinition;
import me.lucko.shadow.ShadowFactory;
import me.lucko.shadow.ShadowingStrategy;
import me.lucko.shadow.Static;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

final class ShadowInvocationHandler
implements InvocationHandler {
    private static final Method GET_SHADOW_TARGET_METHOD;
    private static final Method GET_SHADOW_CLASS_METHOD;
    private static final Method OBJECT_TOSTRING_METHOD;
    private static final Method OBJECT_EQUALS_METHOD;
    private static final Method OBJECT_HASHCODE_METHOD;
    private final @NonNull ShadowFactory shadowFactory;
    private final @NonNull ShadowDefinition shadow;
    private final @Nullable Object handle;

    ShadowInvocationHandler(@NonNull ShadowFactory shadowFactory, @NonNull ShadowDefinition shadow, @Nullable Object handle) {
        this.shadowFactory = shadowFactory;
        this.shadow = shadow;
        this.handle = handle;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object invoke(Object shadowInstance, Method shadowMethod, Object[] args) throws Throwable {
        Object returnValue;
        if (GET_SHADOW_TARGET_METHOD.equals(shadowMethod)) {
            return this.handle;
        }
        if (GET_SHADOW_CLASS_METHOD.equals(shadowMethod)) {
            return this.shadow.getShadowClass();
        }
        if (OBJECT_TOSTRING_METHOD.equals(shadowMethod)) {
            return "Shadow(shadowClass=" + this.shadow.getShadowClass() + ", targetClass=" + this.shadow.getTargetClass() + ", target=" + this.handle + ")";
        }
        if (OBJECT_EQUALS_METHOD.equals(shadowMethod)) {
            Object otherObject = args[0];
            if (otherObject == this) {
                return true;
            }
            if (!(otherObject instanceof Shadow)) {
                return false;
            }
            Shadow other = (Shadow)otherObject;
            return this.shadow.getShadowClass().equals(other.getShadowClass()) && Objects.equals(this.handle, other.getShadowTarget());
        }
        if (OBJECT_HASHCODE_METHOD.equals(shadowMethod)) {
            return this.shadow.getShadowClass().hashCode() ^ Objects.hashCode(this.handle);
        }
        if (shadowMethod.isDefault()) {
            Class<?> declaringClass = shadowMethod.getDeclaringClass();
            return PrivateMethodHandles.forClass(declaringClass).unreflectSpecial(shadowMethod, declaringClass).bindTo(shadowInstance).invokeWithArguments(args);
        }
        if (args == null) {
            args = new Object[]{};
        }
        if (shadowMethod.isAnnotationPresent(Field.class)) {
            ShadowDefinition.TargetField targetField = this.shadow.findTargetField(shadowMethod);
            if (args.length == 0) {
                returnValue = this.bindWithHandle(targetField.getterHandle(), shadowMethod).invoke();
            } else {
                if (args.length != 1) throw new IllegalStateException("Unable to determine accessor type (getter/setter) for " + this.shadow.getTargetClass().getName() + "#" + shadowMethod.getName());
                MethodHandle setter = this.bindWithHandle(targetField.setterHandle(), shadowMethod);
                ShadowingStrategy.Unwrapper unwrapper = ShadowInvocationHandler.getUnwrapper(shadowMethod);
                Class<?> unwrappedType = unwrapper.unwrap(shadowMethod.getParameterTypes()[0], this.shadowFactory);
                Object value = unwrapper.unwrap(args[0], unwrappedType, this.shadowFactory);
                setter.invokeWithArguments(value);
                returnValue = shadowMethod.getReturnType() == Void.TYPE ? null : this.handle;
            }
        } else {
            ShadowingStrategy.Unwrapper unwrapper = ShadowInvocationHandler.getUnwrapper(shadowMethod);
            Class<?>[] unwrappedParameterTypes = unwrapper.unwrapAll(shadowMethod.getParameterTypes(), this.shadowFactory);
            Object[] unwrappedArguments = unwrapper.unwrapAll(args, unwrappedParameterTypes, this.shadowFactory);
            Class<?>[] unwrappedArgumentTypes = ShadowInvocationHandler.getArgumentTypes(unwrappedArguments, unwrappedParameterTypes);
            ShadowDefinition.TargetMethod targetMethod = this.shadow.findTargetMethod(shadowMethod, unwrappedArgumentTypes);
            returnValue = this.bindWithHandle(targetMethod.handle(), shadowMethod).invokeWithArguments(unwrappedArguments);
        }
        ShadowingStrategy.Wrapper wrapper = ShadowInvocationHandler.getWrapper(shadowMethod);
        return wrapper.wrap(returnValue, shadowMethod.getReturnType(), this.shadowFactory);
    }

    static Class<?>[] getArgumentTypes(Object[] arguments, Class<?>[] fallback) {
        Class[] types = new Class[arguments.length];
        for (int i = 0; i < arguments.length; ++i) {
            Object arg = arguments[i];
            types[i] = arg == null ? (fallback == null ? Object.class : fallback[i]) : arg.getClass();
        }
        return types;
    }

    private static ShadowingStrategy.Wrapper getWrapper(Method shadowMethod) {
        ShadowingStrategy shadowingStrategy = shadowMethod.getAnnotation(ShadowingStrategy.class);
        ShadowingStrategy.Wrapper wrapper = shadowingStrategy == null || shadowingStrategy.wrapper() == ShadowingStrategy.Wrapper.class ? ShadowingStrategy.ForShadows.INSTANCE : Reflection.getInstance(ShadowingStrategy.Wrapper.class, shadowingStrategy.wrapper());
        return wrapper;
    }

    private static ShadowingStrategy.Unwrapper getUnwrapper(Method shadowMethod) {
        ShadowingStrategy shadowingStrategy = shadowMethod.getAnnotation(ShadowingStrategy.class);
        ShadowingStrategy.Unwrapper unwrapper = shadowingStrategy == null || shadowingStrategy.unwrapper() == ShadowingStrategy.Unwrapper.class ? ShadowingStrategy.ForShadows.INSTANCE : Reflection.getInstance(ShadowingStrategy.Unwrapper.class, shadowingStrategy.unwrapper());
        return unwrapper;
    }

    private @NonNull MethodHandle bindWithHandle(MethodHandle methodHandle, @NonNull AnnotatedElement annotatedElement) {
        if (annotatedElement.isAnnotationPresent(Static.class)) {
            return methodHandle;
        }
        if (this.handle == null) {
            throw new IllegalStateException("Cannot call non-static method from a static shadow instance.");
        }
        return methodHandle.bindTo(this.handle);
    }

    static {
        try {
            GET_SHADOW_TARGET_METHOD = Shadow.class.getMethod("getShadowTarget", new Class[0]);
            GET_SHADOW_CLASS_METHOD = Shadow.class.getMethod("getShadowClass", new Class[0]);
            OBJECT_TOSTRING_METHOD = Object.class.getMethod("toString", new Class[0]);
            OBJECT_EQUALS_METHOD = Object.class.getMethod("equals", Object.class);
            OBJECT_HASHCODE_METHOD = Object.class.getMethod("hashCode", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

