/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.time;

import java.time.Duration;
import java.time.temporal.ChronoUnit;

public enum DurationFormatter {
    LONG(false, Integer.MAX_VALUE),
    CONCISE(true, Integer.MAX_VALUE),
    CONCISE_LOW_ACCURACY(true, 3);

    private static final Unit[] UNITS;
    private final int accuracy;
    private final boolean concise;

    private DurationFormatter(boolean concise, int accuracy) {
        this.concise = concise;
        this.accuracy = accuracy;
    }

    public String format(Duration duration) {
        return DurationFormatter.format(duration, this.concise, this.accuracy);
    }

    public static String format(Duration duration, boolean concise, int elements) {
        long seconds = duration.getSeconds();
        StringBuilder output = new StringBuilder();
        int outputSize = 0;
        for (Unit unit : UNITS) {
            long n = seconds / unit.duration;
            if (n > 0L) {
                seconds -= unit.duration * n;
                output.append(' ').append(n).append(unit.toString(concise, n));
                ++outputSize;
            }
            if (seconds <= 0L || outputSize >= elements) break;
        }
        if (output.length() == 0) {
            return "0" + UNITS[UNITS.length - 1].toString(concise, 0L);
        }
        return output.substring(1);
    }

    public static String format(Duration duration, boolean concise) {
        return DurationFormatter.format(duration, concise, Integer.MAX_VALUE);
    }

    static {
        UNITS = new Unit[]{new Unit(ChronoUnit.YEARS), new Unit(ChronoUnit.MONTHS), new Unit(ChronoUnit.WEEKS), new Unit(ChronoUnit.DAYS), new Unit(ChronoUnit.HOURS), new Unit(ChronoUnit.MINUTES), new Unit(ChronoUnit.SECONDS)};
    }

    private static final class Unit {
        private final long duration;
        private final String formalStringPlural;
        private final String formalStringSingular;
        private final String conciseString;

        Unit(ChronoUnit unit) {
            this.duration = unit.getDuration().getSeconds();
            this.formalStringPlural = " " + unit.name().toLowerCase();
            this.formalStringSingular = " " + unit.name().substring(0, unit.name().length() - 1).toLowerCase();
            this.conciseString = String.valueOf(Character.toLowerCase(unit.name().charAt(0)));
        }

        public String toString(boolean concise, long n) {
            if (concise) {
                return this.conciseString;
            }
            return n == 1L ? this.formalStringSingular : this.formalStringPlural;
        }
    }
}

