/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.serialize;

import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Objects;
import javax.annotation.Nonnull;
import me.lucko.helper.gson.GsonSerializable;
import me.lucko.helper.gson.JsonBuilder;
import me.lucko.helper.serialize.ChunkPosition;

public final class ChunkRegion
implements GsonSerializable {
    private final ChunkPosition min;
    private final ChunkPosition max;
    private final int width;
    private final int depth;

    public static ChunkRegion deserialize(JsonElement element) {
        Preconditions.checkArgument((boolean)element.isJsonObject());
        JsonObject object = element.getAsJsonObject();
        Preconditions.checkArgument((boolean)object.has("min"));
        Preconditions.checkArgument((boolean)object.has("max"));
        ChunkPosition a = ChunkPosition.deserialize(object.get("min"));
        ChunkPosition b = ChunkPosition.deserialize(object.get("max"));
        return ChunkRegion.of(a, b);
    }

    public static ChunkRegion of(ChunkPosition a, ChunkPosition b) {
        Objects.requireNonNull(a, "a");
        Objects.requireNonNull(b, "b");
        if (!a.getWorld().equals(b.getWorld())) {
            throw new IllegalArgumentException("positions are in different worlds");
        }
        return new ChunkRegion(a, b);
    }

    private ChunkRegion(ChunkPosition a, ChunkPosition b) {
        this.min = ChunkPosition.of(Math.min(a.getX(), b.getX()), Math.min(a.getZ(), b.getZ()), a.getWorld());
        this.max = ChunkPosition.of(Math.max(a.getX(), b.getX()), Math.max(a.getZ(), b.getZ()), a.getWorld());
        this.width = this.max.getX() - this.min.getX();
        this.depth = this.max.getZ() - this.min.getZ();
    }

    public boolean inRegion(ChunkPosition pos) {
        Objects.requireNonNull(pos, "pos");
        return pos.getWorld().equals(this.min.getWorld()) && this.inRegion(pos.getX(), pos.getZ());
    }

    public boolean inRegion(int x, int z) {
        return x >= this.min.getX() && x <= this.max.getX() && z >= this.min.getZ() && z <= this.max.getZ();
    }

    public ChunkPosition getMin() {
        return this.min;
    }

    public ChunkPosition getMax() {
        return this.max;
    }

    public int getWidth() {
        return this.width;
    }

    public int getDepth() {
        return this.depth;
    }

    @Nonnull
    public JsonObject serialize() {
        return JsonBuilder.object().add("min", this.min).add("max", this.max).build();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChunkRegion)) {
            return false;
        }
        ChunkRegion other = (ChunkRegion)o;
        return this.getMin().equals(other.getMin()) && this.getMax().equals(other.getMax());
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMin().hashCode();
        result = result * 59 + this.getMax().hashCode();
        return result;
    }

    public String toString() {
        return "ChunkRegion(min=" + this.getMin() + ", max=" + this.getMax() + ")";
    }
}

