/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.scheduler;

import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import me.lucko.helper.internal.LoaderUtils;
import me.lucko.helper.internal.exception.HelperExceptions;
import me.lucko.helper.scheduler.HelperAsyncExecutor;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public final class HelperExecutors {
    private static final Executor SYNC_BUKKIT = new BukkitSyncExecutor();
    private static final Executor ASYNC_BUKKIT = new BukkitAsyncExecutor();
    private static final HelperAsyncExecutor ASYNC_HELPER = new HelperAsyncExecutor();

    public static Executor sync() {
        return SYNC_BUKKIT;
    }

    public static ScheduledExecutorService asyncHelper() {
        return ASYNC_HELPER;
    }

    public static Executor asyncBukkit() {
        return ASYNC_BUKKIT;
    }

    public static void shutdown() {
        ASYNC_HELPER.cancelRepeatingTasks();
    }

    @Deprecated
    public static Runnable wrapRunnable(Runnable runnable) {
        return HelperExceptions.wrapSchedulerTask(runnable);
    }

    private HelperExecutors() {
    }

    private static final class BukkitAsyncExecutor
    implements Executor {
        private BukkitAsyncExecutor() {
        }

        @Override
        public void execute(Runnable runnable) {
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)LoaderUtils.getPlugin(), HelperExceptions.wrapSchedulerTask(runnable));
        }
    }

    private static final class BukkitSyncExecutor
    implements Executor {
        private BukkitSyncExecutor() {
        }

        @Override
        public void execute(Runnable runnable) {
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)LoaderUtils.getPlugin(), HelperExceptions.wrapSchedulerTask(runnable));
        }
    }
}

