/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.network.modules;

import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import me.lucko.helper.Commands;
import me.lucko.helper.Helper;
import me.lucko.helper.Schedulers;
import me.lucko.helper.messaging.InstanceData;
import me.lucko.helper.messaging.Messenger;
import me.lucko.helper.messaging.conversation.ConversationChannel;
import me.lucko.helper.messaging.conversation.ConversationMessage;
import me.lucko.helper.messaging.conversation.ConversationReply;
import me.lucko.helper.messaging.conversation.ConversationReplyListener;
import me.lucko.helper.terminable.TerminableConsumer;
import me.lucko.helper.terminable.module.TerminableModule;
import me.lucko.helper.utils.Players;
import org.bukkit.command.CommandException;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class DispatchModule
implements TerminableModule {
    private final Messenger messenger;
    private final InstanceData instanceData;
    private final String[] commandAliases;

    public DispatchModule(Messenger messenger, InstanceData instanceData) {
        this(messenger, instanceData, new String[]{"dispatch"});
    }

    public DispatchModule(Messenger messenger, InstanceData instanceData, String[] commandAliases) {
        this.messenger = messenger;
        this.instanceData = instanceData;
        this.commandAliases = commandAliases;
    }

    @Override
    public void setup(@Nonnull TerminableConsumer consumer) {
        ConversationChannel<DispatchMessage, DispatchReply> dispatchChannel = this.messenger.getConversationChannel("hlp-dispatch", DispatchMessage.class, DispatchReply.class);
        dispatchChannel.newAgent((agent, message) -> {
            Players.stream().filter(p -> p.hasPermission("helper.dispatchalert")).filter(p -> !p.getUniqueId().equals(((DispatchMessage)message).senderUuid)).forEach(p -> Players.msg((CommandSender)p, "&7[&anetwork&7] &2" + ((DispatchMessage)message).senderName + "&7 on &2" + ((DispatchMessage)message).senderLocation + "&7 dispatched command '&f" + ((DispatchMessage)message).command + "&7' to '&2" + ((DispatchMessage)message).target + "&7'."));
            if (!(((DispatchMessage)message).target.equals("all") || this.instanceData.getGroups().contains(((DispatchMessage)message).target) || this.instanceData.getId().equals(((DispatchMessage)message).target))) {
                return ConversationReply.noReply();
            }
            return ConversationReply.ofPromise(Schedulers.sync().supply(() -> {
                boolean success = false;
                try {
                    success = Helper.server().dispatchCommand((CommandSender)Helper.console(), ((DispatchMessage)message).command);
                }
                catch (CommandException commandException) {
                    // empty catch block
                }
                DispatchReply reply = new DispatchReply();
                reply.convoId = ((DispatchMessage)message).convoId;
                reply.server = this.instanceData.getId();
                reply.success = success;
                return reply;
            }));
        }).bindWith(consumer);
        Commands.create().assertPermission("helper.dispatch").assertUsage("<target> <command>").handler(c -> {
            String target = c.arg(0).parseOrFail(String.class).toLowerCase();
            final String command = c.args().stream().skip(1L).collect(Collectors.joining(" "));
            DispatchMessage dispatch = new DispatchMessage();
            dispatch.convoId = UUID.randomUUID();
            dispatch.command = command;
            dispatch.target = target;
            if (c.sender() instanceof Player) {
                dispatch.senderUuid = ((Player)c.sender()).getUniqueId();
            }
            dispatch.senderName = c.sender().getName();
            dispatch.senderLocation = this.instanceData.getId();
            dispatchChannel.sendMessage(dispatch, new ConversationReplyListener<DispatchReply>(){

                @Override
                @Nonnull
                public ConversationReplyListener.RegistrationAction onReply(@Nonnull DispatchReply reply) {
                    if (reply.success) {
                        Players.msg(c.sender(), new String[]{"&7[&anetwork&7] Dispatched command '&f" + command + "&7' was &asuccessfully executed&7 on &2" + reply.server + "&7."});
                    } else {
                        Players.msg(c.sender(), new String[]{"&7[&anetwork&7] Dispatched command '&f" + command + "&7' could &cnot be successfully executed&7 on &2" + reply.server + "&7."});
                    }
                    return ConversationReplyListener.RegistrationAction.CONTINUE_LISTENING;
                }

                @Override
                public void onTimeout(@Nonnull List<DispatchReply> replies) {
                    if (replies.isEmpty()) {
                        Players.msg(c.sender(), new String[]{"&7[&anetwork&7] Dispatched command '&f" + command + "&7' was not acknowledged by any servers."});
                    }
                }
            }, 3L, TimeUnit.SECONDS);
            Players.msg(c.sender(), new String[]{"&7[&anetwork&7] Dispatched command '&f" + command + "&7' to '&2" + target + "&7'."});
        }).registerAndBind(consumer, this.commandAliases);
    }

    private static final class DispatchReply
    implements ConversationMessage {
        private UUID convoId;
        private String server;
        private boolean success;

        private DispatchReply() {
        }

        @Override
        @Nonnull
        public UUID getConversationId() {
            return this.convoId;
        }
    }

    private static final class DispatchMessage
    implements ConversationMessage {
        private UUID convoId;
        private String command;
        private String target;
        private UUID senderUuid;
        private String senderName;
        private String senderLocation;

        private DispatchMessage() {
        }

        @Override
        @Nonnull
        public UUID getConversationId() {
            return this.convoId;
        }
    }
}

