/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.menu.scheme;

import com.google.common.collect.Range;
import java.util.Arrays;
import me.lucko.helper.item.ItemStackBuilder;
import me.lucko.helper.menu.scheme.EmptySchemeMapping;
import me.lucko.helper.menu.scheme.FunctionalSchemeMapping;
import me.lucko.helper.menu.scheme.SchemeMapping;
import me.lucko.helper.utils.annotation.NonnullByDefault;
import org.bukkit.Material;

@NonnullByDefault
public final class StandardSchemeMappings {
    private static final Range<Integer> COLORED_MATERIAL_RANGE = Range.closed((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(15));
    private static final String[] BLOCK_COLORS = new String[]{"WHITE", "ORANGE", "MAGENTA", "LIGHT_BLUE", "YELLOW", "LIME", "PINK", "GRAY", "LIGHT_GRAY", "CYAN", "PURPLE", "BLUE", "BROWN", "GREEN", "RED", "BLACK"};
    public static final SchemeMapping STAINED_GLASS = StandardSchemeMappings.forColoredMaterial("STAINED_GLASS_PANE", "_STAINED_GLASS_PANE");
    public static final SchemeMapping STAINED_GLASS_BLOCK = StandardSchemeMappings.forColoredMaterial("STAINED_GLASS", "_STAINED_GLASS");
    public static final SchemeMapping HARDENED_CLAY = StandardSchemeMappings.forColoredMaterial("STAINED_CLAY", "_TERRACOTTA");
    public static final SchemeMapping WOOL = StandardSchemeMappings.forColoredMaterial("WOOL", "_WOOL");
    public static final SchemeMapping EMPTY = new EmptySchemeMapping();

    private static SchemeMapping forColoredMaterial(String legacyName, String modernSuffix) {
        Material material = Material.getMaterial((String)legacyName);
        if (material != null) {
            return FunctionalSchemeMapping.of(data -> ItemStackBuilder.of(material).name("&f").data(data).build(null), COLORED_MATERIAL_RANGE);
        }
        Material[] materials = (Material[])Arrays.stream(BLOCK_COLORS).map(color -> Material.valueOf((String)(color + modernSuffix))).toArray(Material[]::new);
        return FunctionalSchemeMapping.of(data -> ItemStackBuilder.of(materials[data]).name("&f").build(null), COLORED_MATERIAL_RANGE);
    }

    private StandardSchemeMappings() {
        throw new UnsupportedOperationException("This class cannot be instantiated");
    }
}

