/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.config.objectmapping;

import com.google.common.reflect.TypeToken;
import com.google.inject.ConfigurationException;
import com.google.inject.Injector;
import com.google.inject.Key;
import java.lang.reflect.Type;
import me.lucko.helper.config.objectmapping.ObjectMapper;
import me.lucko.helper.config.objectmapping.ObjectMappingException;
import org.checkerframework.checker.nullness.qual.NonNull;

class GuiceObjectMapper<T>
extends ObjectMapper<T> {
    private final Injector injector;
    private final Key<T> typeKey;

    protected GuiceObjectMapper(@NonNull Injector injector, @NonNull TypeToken<T> clazz) throws ObjectMappingException {
        super(clazz);
        this.injector = injector;
        this.typeKey = Key.get((Type)clazz.getType());
    }

    @Override
    public boolean canCreateInstances() {
        try {
            this.injector.getProvider(this.typeKey);
            return true;
        }
        catch (ConfigurationException ex) {
            return false;
        }
    }

    @Override
    protected T constructObject() throws ObjectMappingException {
        return (T)this.injector.getInstance(this.typeKey);
    }
}

