/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.command.functional;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.lucko.helper.command.AbstractCommand;
import me.lucko.helper.command.CommandInterruptException;
import me.lucko.helper.command.context.CommandContext;
import me.lucko.helper.command.functional.FunctionalCommandHandler;
import me.lucko.helper.command.functional.FunctionalTabHandler;
import me.lucko.helper.utils.annotation.NonnullByDefault;

@NonnullByDefault
class FunctionalCommand
extends AbstractCommand {
    private final ImmutableList<Predicate<CommandContext<?>>> predicates;
    private final FunctionalCommandHandler handler;
    @Nullable
    private final FunctionalTabHandler tabHandler;

    FunctionalCommand(ImmutableList<Predicate<CommandContext<?>>> predicates, FunctionalCommandHandler handler, @Nullable FunctionalTabHandler tabHandler, @Nullable String permission, @Nullable String permissionMessage, @Nullable String description) {
        this.predicates = predicates;
        this.handler = handler;
        this.tabHandler = tabHandler;
        this.permission = permission;
        this.permissionMessage = permissionMessage;
        this.description = description;
    }

    @Override
    public void call(@Nonnull CommandContext<?> context) throws CommandInterruptException {
        for (Predicate predicate : this.predicates) {
            if (predicate.test(context)) continue;
            return;
        }
        this.handler.handle(context);
    }

    @Override
    @Nullable
    public List<String> callTabCompleter(@Nonnull CommandContext<?> context) throws CommandInterruptException {
        if (this.tabHandler == null) {
            return null;
        }
        for (Predicate predicate : this.predicates) {
            if (predicate.test(context)) continue;
            return null;
        }
        return this.tabHandler.handle(context);
    }
}

