/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.utils;

import java.util.Optional;
import javax.annotation.Nullable;
import me.lucko.helper.Events;
import me.lucko.helper.Helper;
import me.lucko.helper.event.MergedSubscription;
import me.lucko.helper.terminable.Terminable;
import me.lucko.helper.utils.annotation.NonnullByDefault;
import org.bukkit.event.server.ServiceEvent;
import org.bukkit.event.server.ServiceRegisterEvent;
import org.bukkit.event.server.ServiceUnregisterEvent;

@NonnullByDefault
public final class ServiceCallback<T>
implements Terminable {
    @Nullable
    private T instance = null;
    private Class<T> serviceClass;
    private final MergedSubscription<ServiceEvent> listener;

    public static <T> ServiceCallback<T> of(Class<T> serviceClass) {
        return new ServiceCallback<T>(serviceClass);
    }

    private ServiceCallback(Class<T> serviceClass) {
        this.serviceClass = serviceClass;
        this.refresh();
        this.listener = Events.merge(ServiceEvent.class, ServiceRegisterEvent.class, ServiceUnregisterEvent.class).filter(e -> e.getProvider() != null && e.getProvider().getService().equals(serviceClass)).handler(e -> this.refresh());
    }

    public void refresh() {
        this.instance = Helper.serviceNullable(this.serviceClass);
    }

    @Nullable
    public T getNullable() {
        return this.instance;
    }

    public Optional<T> get() {
        return Optional.ofNullable(this.instance);
    }

    @Override
    public void close() {
        this.listener.close();
    }

    @Override
    public boolean isClosed() {
        return this.listener.isClosed();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServiceCallback)) {
            return false;
        }
        ServiceCallback other = (ServiceCallback)o;
        return this.serviceClass.equals(other.serviceClass);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.serviceClass.hashCode();
        return result;
    }

    public String toString() {
        return "ServiceCallback(serviceClass=" + this.serviceClass + ")";
    }
}

