/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.setting;

import java.util.Arrays;
import java.util.BitSet;
import java.util.Objects;
import me.lucko.helper.setting.BooleanSetting;
import me.lucko.helper.setting.BooleanSettingMap;
import me.lucko.helper.setting.SettingMapFactory;

public final class BooleanSettingMapFactory<S extends BooleanSetting> {
    private final S[] settings;
    private final BitSet defaultBits;

    public static <S extends Enum<S>> BooleanSettingMapFactory<S> create(Class<S> settingsEnum) {
        Objects.requireNonNull(settingsEnum, "settingsEnum");
        return BooleanSettingMapFactory.create((BooleanSetting[])((Enum[])settingsEnum.getEnumConstants()));
    }

    public static <S extends BooleanSetting> BooleanSettingMapFactory<S> create(S[] settings) {
        Objects.requireNonNull(settings, "settings");
        BitSet defaultBits = new BitSet();
        for (int i = 0; i < settings.length; ++i) {
            S setting = settings[i];
            if (setting.ordinal() != i) {
                throw new IllegalArgumentException("The ordinal of setting " + setting + " does not equal its array index. ordinal=" + setting.ordinal() + ", index=" + i);
            }
            if (!setting.defaultState()) continue;
            defaultBits.set(i);
        }
        return new BooleanSettingMapFactory(settings, defaultBits);
    }

    private BooleanSettingMapFactory(S[] settings, BitSet defaultBits) {
        this.settings = settings;
        this.defaultBits = defaultBits;
    }

    public S[] getSettings() {
        return (BooleanSetting[])Arrays.copyOf(this.settings, this.settings.length);
    }

    boolean isDifferentFromDefault(BitSet bits) {
        return !this.defaultBits.equals(bits);
    }

    public BooleanSettingMap<S> newMap() {
        return new BooleanSettingMap(this, BitSet.valueOf(this.defaultBits.toLongArray()));
    }

    public BooleanSettingMap<S> decode(byte[] buf) {
        BitSet bits = BitSet.valueOf(buf);
        if (bits.length() > this.settings.length) {
            bits.clear(this.settings.length, bits.length());
        }
        return new BooleanSettingMap(this, bits);
    }

    public BooleanSettingMap<S> decode(String encodedString) {
        return this.decode(SettingMapFactory.ENCODING.decode((CharSequence)encodedString));
    }
}

