/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.reflect;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.Locale;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;

public class SnapshotVersion
implements Comparable<SnapshotVersion> {
    public static final Comparator<SnapshotVersion> COMPARATOR = Comparator.nullsFirst(Comparator.comparing(SnapshotVersion::getSnapshotDate).thenComparing(SnapshotVersion::getSnapshotWeekVersion));
    private static final Pattern SNAPSHOT_PATTERN = Pattern.compile("(\\d{2}w\\d{2})([a-z])");
    private final Date snapshotDate;
    private final int snapshotWeekVersion;
    private transient String rawString;

    @Nonnull
    public static SnapshotVersion parse(String version) throws IllegalArgumentException {
        return new SnapshotVersion(version);
    }

    private SnapshotVersion(String version) {
        Matcher matcher = SNAPSHOT_PATTERN.matcher(version.trim());
        if (matcher.matches()) {
            try {
                this.snapshotDate = SnapshotVersion.getDateFormat().parse(matcher.group(1));
                this.snapshotWeekVersion = matcher.group(2).charAt(0) - 97;
                this.rawString = version;
            }
            catch (ParseException e) {
                throw new IllegalArgumentException("Date implied by snapshot version is invalid.", e);
            }
        } else {
            throw new IllegalArgumentException("Cannot parse " + version + " as a snapshot version.");
        }
    }

    private static SimpleDateFormat getDateFormat() {
        SimpleDateFormat format = new SimpleDateFormat("yy'w'ww", Locale.US);
        format.setLenient(false);
        return format;
    }

    public int getSnapshotWeekVersion() {
        return this.snapshotWeekVersion;
    }

    public Date getSnapshotDate() {
        return this.snapshotDate;
    }

    public String getSnapshotString() {
        if (this.rawString == null) {
            Calendar current = Calendar.getInstance(Locale.US);
            current.setTime(this.snapshotDate);
            this.rawString = String.format("%02dw%02d%s", current.get(1) % 100, current.get(3), Character.valueOf((char)(97 + this.snapshotWeekVersion)));
        }
        return this.rawString;
    }

    @Override
    public int compareTo(SnapshotVersion that) {
        return COMPARATOR.compare(this, that);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SnapshotVersion)) {
            return false;
        }
        SnapshotVersion other = (SnapshotVersion)obj;
        return Objects.equals(this.snapshotDate, other.getSnapshotDate()) && this.snapshotWeekVersion == other.getSnapshotWeekVersion();
    }

    public int hashCode() {
        return Objects.hash(this.snapshotDate, this.snapshotWeekVersion);
    }

    public String toString() {
        return this.getSnapshotString();
    }
}

