/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.network;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import me.lucko.helper.Schedulers;
import me.lucko.helper.cooldown.Cooldown;
import me.lucko.helper.eventbus.EventBus;
import me.lucko.helper.eventbus.EventSubscriber;
import me.lucko.helper.eventbus.PostResult;
import me.lucko.helper.eventbus.SimpleEventBus;
import me.lucko.helper.internal.LoaderUtils;
import me.lucko.helper.messaging.Channel;
import me.lucko.helper.messaging.InstanceData;
import me.lucko.helper.messaging.Messenger;
import me.lucko.helper.network.Network;
import me.lucko.helper.network.Server;
import me.lucko.helper.network.event.NetworkEvent;
import me.lucko.helper.network.event.ServerConnectEvent;
import me.lucko.helper.network.event.ServerDisconnectEvent;
import me.lucko.helper.network.event.ServerStatusEvent;
import me.lucko.helper.network.metadata.ServerMetadata;
import me.lucko.helper.network.metadata.ServerMetadataProvider;
import me.lucko.helper.network.metadata.TpsMetadataProvider;
import me.lucko.helper.profiles.Profile;
import me.lucko.helper.terminable.composite.CompositeTerminable;
import me.lucko.helper.utils.Players;
import org.bukkit.Bukkit;
import org.checkerframework.checker.nullness.qual.NonNull;

public class AbstractNetwork
implements Network {
    protected final CompositeTerminable compositeTerminable = CompositeTerminable.create();
    protected final Messenger messenger;
    protected final InstanceData instanceData;
    private final EventBus<NetworkEvent> eventBus = new SimpleEventBus<NetworkEvent>(NetworkEvent.class);
    private final List<ServerMetadataProvider> metadataProviders = new CopyOnWriteArrayList<ServerMetadataProvider>();
    private final Map<String, ServerImpl> servers = new ConcurrentHashMap<String, ServerImpl>();

    public AbstractNetwork(Messenger messenger, final InstanceData instanceData) {
        this.messenger = messenger;
        this.instanceData = instanceData;
        final Channel<EventMessage> eventsChannel = messenger.getChannel("hnet-events", EventMessage.class);
        eventsChannel.newAgent((agent, message) -> {
            switch (((EventMessage)message).type) {
                case "connect": {
                    this.postEvent(new ServerConnectEvent(((EventMessage)message).id, this.handleIncomingStatusMessage(((EventMessage)message).status)));
                    break;
                }
                case "disconnect": {
                    if (instanceData.getId().equals(((EventMessage)message).id)) break;
                    this.postEvent(new ServerDisconnectEvent(((EventMessage)message).id, ((EventMessage)message).reason));
                }
            }
        }).bindWith(this.compositeTerminable);
        EventSubscriber<ServerDisconnectEvent> disconnectListener = new EventSubscriber<ServerDisconnectEvent>(){

            @Override
            public void invoke(@NonNull ServerDisconnectEvent event) {
                if (!event.getId().equals(instanceData.getId())) {
                    return;
                }
                EventMessage message = new EventMessage();
                message.id = event.getId();
                message.type = "disconnect";
                message.reason = event.getReason();
                eventsChannel.sendMessage(message);
                AbstractNetwork.this.eventBus.unregister(this);
            }
        };
        this.eventBus.register(ServerDisconnectEvent.class, disconnectListener);
        LoaderUtils.getPlugin().bind(() -> this.postEvent(new ServerDisconnectEvent(instanceData.getId(), "stopping")));
        this.registerMetadataProviders();
        EventMessage connectionMessage = new EventMessage();
        connectionMessage.id = instanceData.getId();
        connectionMessage.type = "connect";
        connectionMessage.status = this.produceStatusMessage();
        eventsChannel.sendMessage(connectionMessage);
        Channel<StatusMessage> statusChannel = messenger.getChannel("hnet-status", StatusMessage.class);
        statusChannel.newAgent((agent, message) -> this.handleIncomingStatusMessage((StatusMessage)message)).bindWith(this.compositeTerminable);
        Schedulers.builder().async().afterAndEvery(3L, TimeUnit.SECONDS).run(() -> {
            StatusMessage msg = this.produceStatusMessage();
            statusChannel.sendMessage(msg);
        }).bindWith(this.compositeTerminable);
    }

    protected void registerMetadataProviders() {
        this.registerMetadataProvider(TpsMetadataProvider.INSTANCE);
    }

    protected void postEvent(NetworkEvent event) {
        try {
            this.eventBus.post(event).raise();
        }
        catch (PostResult.CompositeException e) {
            throw new RuntimeException(e);
        }
    }

    private StatusMessage produceStatusMessage() {
        StatusMessage msg = new StatusMessage();
        msg.time = System.currentTimeMillis();
        msg.id = this.instanceData.getId();
        msg.groups = new ArrayList<String>(this.instanceData.getGroups());
        msg.players = new HashMap();
        Players.forEach(p -> msg.players.put(p.getUniqueId(), p.getName()));
        msg.maxPlayers = Bukkit.getMaxPlayers();
        msg.whitelisted = Bukkit.hasWhitelist();
        msg.metadata = new HashMap();
        for (ServerMetadataProvider metadataProvider : this.metadataProviders) {
            try {
                for (ServerMetadata metadata : metadataProvider.provide()) {
                    msg.metadata.put(metadata.key(), metadata.data());
                }
            }
            catch (Exception e) {
                new RuntimeException("Exception calling ServerMetadataProvider " + metadataProvider, e).printStackTrace();
            }
        }
        return msg;
    }

    private ServerImpl handleIncomingStatusMessage(StatusMessage message) {
        ServerImpl server = this.servers.computeIfAbsent(message.id, ServerImpl::new);
        server.loadData(message);
        this.postEvent(new ServerStatusEvent(server));
        return server;
    }

    @Override
    public Map<String, Server> getServers() {
        return Collections.unmodifiableMap(this.servers);
    }

    @Override
    public Map<UUID, Profile> getOnlinePlayers() {
        HashMap<UUID, Profile> players = new HashMap<UUID, Profile>();
        for (Server server : this.servers.values()) {
            players.putAll(server.getOnlinePlayers());
        }
        return Collections.unmodifiableMap(players);
    }

    @Override
    public int getOverallPlayerCount() {
        return this.servers.values().stream().mapToInt(s -> s.getOnlinePlayers().size()).sum();
    }

    @Override
    public void registerMetadataProvider(ServerMetadataProvider metadataProvider) {
        this.metadataProviders.add(metadataProvider);
    }

    @Override
    public EventBus<NetworkEvent> getEventBus() {
        return this.eventBus;
    }

    @Override
    public void close() {
        this.compositeTerminable.closeAndReportException();
    }

    private static final class EventMessage {
        private String id;
        private String type;
        private String reason;
        private StatusMessage status;

        private EventMessage() {
        }
    }

    private static final class StatusMessage {
        private String id;
        private List<String> groups;
        private long time;
        private Map<UUID, String> players;
        private int maxPlayers;
        private boolean whitelisted;
        private Map<String, JsonElement> metadata;

        private StatusMessage() {
        }
    }

    private static final class ServerImpl
    implements Server {
        private static final long TIME_SYNC_THRESHOLD = TimeUnit.SECONDS.toMillis(2L);
        private final String id;
        private long lastPing = 0L;
        private Set<String> groups = ImmutableSet.of();
        private Map<UUID, Profile> players = ImmutableMap.of();
        private int maxPlayers = 0;
        private boolean whitelisted = false;
        private Map<String, JsonElement> metadata;
        private final Cooldown timeSyncWarningCooldown = Cooldown.of(5L, TimeUnit.SECONDS);

        ServerImpl(String id) {
            this.id = id;
        }

        private void checkTimeSync(long messageTimestamp) {
            long systemTime = System.currentTimeMillis();
            long timeDifference = Math.abs(systemTime - messageTimestamp);
            if (timeDifference > TIME_SYNC_THRESHOLD && this.timeSyncWarningCooldown.test()) {
                LoaderUtils.getPlugin().getLogger().warning("[network] Server '" + this.id + "' appears to have a system time difference of " + timeDifference + " ms. time now = " + systemTime + ", message timestamp = " + messageTimestamp + " - Check NTP is running? Is network stable?");
            }
        }

        private void loadData(StatusMessage msg) {
            this.checkTimeSync(msg.time);
            this.lastPing = msg.time;
            this.groups = ImmutableSet.copyOf((Collection)msg.groups);
            ImmutableMap.Builder players = ImmutableMap.builder();
            for (Map.Entry p : msg.players.entrySet()) {
                players.put((Object)((UUID)p.getKey()), (Object)Profile.create((UUID)p.getKey(), (String)p.getValue()));
            }
            this.players = players.build();
            this.maxPlayers = msg.maxPlayers;
            this.whitelisted = msg.whitelisted;
            this.metadata = ImmutableMap.copyOf((Map)msg.metadata);
        }

        @Override
        @Nonnull
        public String getId() {
            return this.id;
        }

        @Override
        @Nonnull
        public Set<String> getGroups() {
            return this.groups;
        }

        @Override
        public boolean isOnline() {
            long diff = System.currentTimeMillis() - this.lastPing;
            return diff < TimeUnit.SECONDS.toMillis(5L);
        }

        @Override
        public long getLastPing() {
            return this.lastPing;
        }

        @Override
        public Map<UUID, Profile> getOnlinePlayers() {
            if (!this.isOnline()) {
                return ImmutableMap.of();
            }
            return this.players;
        }

        @Override
        public int getMaxPlayers() {
            if (!this.isOnline()) {
                return 0;
            }
            return this.maxPlayers;
        }

        @Override
        public boolean isFull() {
            return this.players.size() >= this.maxPlayers;
        }

        @Override
        public boolean isWhitelisted() {
            return this.whitelisted;
        }

        @Override
        public Map<String, JsonElement> getRawMetadata() {
            if (!this.isOnline()) {
                return ImmutableMap.of();
            }
            return this.metadata;
        }
    }
}

