/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.event.functional.merged;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import me.lucko.helper.event.MergedSubscription;
import me.lucko.helper.event.functional.merged.HelperMergedEventListener;
import me.lucko.helper.event.functional.merged.MergedHandlerList;
import me.lucko.helper.event.functional.merged.MergedSubscriptionBuilderImpl;
import me.lucko.helper.internal.LoaderUtils;

class MergedHandlerListImpl<T>
implements MergedHandlerList<T> {
    private final MergedSubscriptionBuilderImpl<T> builder;
    private final List<BiConsumer<MergedSubscription<T>, ? super T>> handlers = new ArrayList<BiConsumer<MergedSubscription<T>, ? super T>>(1);

    MergedHandlerListImpl(@Nonnull MergedSubscriptionBuilderImpl<T> builder) {
        this.builder = builder;
    }

    @Override
    @Nonnull
    public MergedHandlerList<T> biConsumer(@Nonnull BiConsumer<MergedSubscription<T>, ? super T> handler) {
        Objects.requireNonNull(handler, "handler");
        this.handlers.add(handler);
        return this;
    }

    @Override
    @Nonnull
    public MergedSubscription<T> register() {
        if (this.handlers.isEmpty()) {
            throw new IllegalStateException("No handlers have been registered");
        }
        HelperMergedEventListener<T> listener = new HelperMergedEventListener<T>(this.builder, this.handlers);
        listener.register(LoaderUtils.getPlugin());
        return listener;
    }
}

