/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.command.functional;

import java.util.function.Predicate;
import javax.annotation.Nullable;
import me.lucko.helper.command.Command;
import me.lucko.helper.command.context.CommandContext;
import me.lucko.helper.command.functional.FunctionalCommandBuilderImpl;
import me.lucko.helper.command.functional.FunctionalCommandHandler;
import me.lucko.helper.utils.annotation.NonnullByDefault;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;

@NonnullByDefault
public interface FunctionalCommandBuilder<T extends CommandSender> {
    public static final String DEFAULT_NOT_OP_MESSAGE = "&cOnly server operators are able to use this command.";
    public static final String DEFAULT_NOT_PLAYER_MESSAGE = "&cOnly players are able to use this command.";
    public static final String DEFAULT_NOT_CONSOLE_MESSAGE = "&cThis command is only available through the server console.";
    public static final String DEFAULT_INVALID_USAGE_MESSAGE = "&cInvalid usage. Try: {usage}.";
    public static final String DEFAULT_INVALID_ARGUMENT_MESSAGE = "&cInvalid argument '{arg}' at index {index}.";
    public static final String DEFAULT_INVALID_SENDER_MESSAGE = "&cYou are not able to use this command.";

    public static FunctionalCommandBuilder<CommandSender> newBuilder() {
        return new FunctionalCommandBuilderImpl<CommandSender>();
    }

    public FunctionalCommandBuilder<T> description(String var1);

    public FunctionalCommandBuilder<T> assertFunction(Predicate<? super CommandContext<? extends T>> var1);

    default public FunctionalCommandBuilder<T> assertPermission(String permission) {
        return this.assertPermission(permission, null);
    }

    public FunctionalCommandBuilder<T> assertPermission(String var1, @Nullable String var2);

    default public FunctionalCommandBuilder<T> assertOp() {
        return this.assertOp(DEFAULT_NOT_OP_MESSAGE);
    }

    public FunctionalCommandBuilder<T> assertOp(String var1);

    default public FunctionalCommandBuilder<Player> assertPlayer() {
        return this.assertPlayer(DEFAULT_NOT_PLAYER_MESSAGE);
    }

    public FunctionalCommandBuilder<Player> assertPlayer(String var1);

    default public FunctionalCommandBuilder<ConsoleCommandSender> assertConsole() {
        return this.assertConsole(DEFAULT_NOT_CONSOLE_MESSAGE);
    }

    public FunctionalCommandBuilder<ConsoleCommandSender> assertConsole(String var1);

    default public FunctionalCommandBuilder<T> assertUsage(String usage) {
        return this.assertUsage(usage, DEFAULT_INVALID_USAGE_MESSAGE);
    }

    public FunctionalCommandBuilder<T> assertUsage(String var1, String var2);

    default public FunctionalCommandBuilder<T> assertArgument(int index, Predicate<String> test) {
        return this.assertArgument(index, test, DEFAULT_INVALID_ARGUMENT_MESSAGE);
    }

    public FunctionalCommandBuilder<T> assertArgument(int var1, Predicate<String> var2, String var3);

    default public FunctionalCommandBuilder<T> assertSender(Predicate<T> test) {
        return this.assertSender(test, DEFAULT_INVALID_SENDER_MESSAGE);
    }

    public FunctionalCommandBuilder<T> assertSender(Predicate<T> var1, String var2);

    public Command handler(FunctionalCommandHandler<T> var1);
}

