/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.bucket.factory;

import java.util.Set;
import java.util.function.Supplier;
import me.lucko.helper.bucket.Bucket;
import me.lucko.helper.bucket.factory.ConcurrentBucket;
import me.lucko.helper.bucket.factory.HashSetBucket;
import me.lucko.helper.bucket.factory.SetSuppliedBucket;
import me.lucko.helper.bucket.factory.SynchronizedHashSetBucket;
import me.lucko.helper.bucket.partitioning.PartitioningStrategy;

public final class BucketFactory {
    public static <E> Bucket<E> newBucket(int size, PartitioningStrategy<E> strategy, Supplier<Set<E>> setSupplier) {
        return new SetSuppliedBucket<E>(size, strategy, setSupplier);
    }

    public static <E> Bucket<E> newHashSetBucket(int size, PartitioningStrategy<E> strategy) {
        return new HashSetBucket<E>(size, strategy);
    }

    public static <E> Bucket<E> newSynchronizedHashSetBucket(int size, PartitioningStrategy<E> strategy) {
        return new SynchronizedHashSetBucket<E>(size, strategy);
    }

    public static <E> Bucket<E> newConcurrentBucket(int size, PartitioningStrategy<E> strategy) {
        return new ConcurrentBucket<E>(size, strategy);
    }

    private BucketFactory() {
        throw new UnsupportedOperationException("This class cannot be instantiated");
    }
}

