/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.text3.renderer;

import me.lucko.helper.text3.BlockNbtComponent;
import me.lucko.helper.text3.Component;
import me.lucko.helper.text3.EntityNbtComponent;
import me.lucko.helper.text3.KeybindComponent;
import me.lucko.helper.text3.NbtComponent;
import me.lucko.helper.text3.ScoreComponent;
import me.lucko.helper.text3.SelectorComponent;
import me.lucko.helper.text3.StorageNbtComponent;
import me.lucko.helper.text3.TextComponent;
import me.lucko.helper.text3.TranslatableComponent;
import me.lucko.helper.text3.renderer.ComponentRenderer;
import org.checkerframework.checker.nullness.qual.NonNull;

public abstract class AbstractComponentRenderer<C>
implements ComponentRenderer<C> {
    @Override
    public @NonNull Component render(@NonNull Component component, @NonNull C context) {
        if (component instanceof TextComponent) {
            return this.renderText((TextComponent)component, context);
        }
        if (component instanceof TranslatableComponent) {
            return this.renderTranslatable((TranslatableComponent)component, context);
        }
        if (component instanceof KeybindComponent) {
            return this.renderKeybind((KeybindComponent)component, context);
        }
        if (component instanceof ScoreComponent) {
            return this.renderScore((ScoreComponent)component, context);
        }
        if (component instanceof SelectorComponent) {
            return this.renderSelector((SelectorComponent)component, context);
        }
        if (component instanceof NbtComponent) {
            if (component instanceof BlockNbtComponent) {
                return this.renderBlockNbt((BlockNbtComponent)component, context);
            }
            if (component instanceof EntityNbtComponent) {
                return this.renderEntityNbt((EntityNbtComponent)component, context);
            }
            if (component instanceof StorageNbtComponent) {
                return this.renderStorageNbt((StorageNbtComponent)component, context);
            }
        }
        return component;
    }

    protected abstract @NonNull Component renderBlockNbt(@NonNull BlockNbtComponent var1, @NonNull C var2);

    protected abstract @NonNull Component renderEntityNbt(@NonNull EntityNbtComponent var1, @NonNull C var2);

    protected abstract @NonNull Component renderStorageNbt(@NonNull StorageNbtComponent var1, @NonNull C var2);

    protected abstract @NonNull Component renderKeybind(@NonNull KeybindComponent var1, @NonNull C var2);

    protected abstract @NonNull Component renderScore(@NonNull ScoreComponent var1, @NonNull C var2);

    protected abstract @NonNull Component renderSelector(@NonNull SelectorComponent var1, @NonNull C var2);

    protected abstract @NonNull Component renderText(@NonNull TextComponent var1, @NonNull C var2);

    protected abstract @NonNull Component renderTranslatable(@NonNull TranslatableComponent var1, @NonNull C var2);
}

