/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.setting;

import com.google.common.io.BaseEncoding;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import java.util.Arrays;
import java.util.Objects;
import me.lucko.helper.setting.Setting;
import me.lucko.helper.setting.SettingMap;

public final class SettingMapFactory<S extends Setting<V>, V extends Setting.State> {
    static final BaseEncoding ENCODING = BaseEncoding.base64().omitPadding();
    final S[] settings;
    final V[] states;
    private final byte[] defaultStates;

    public static <S extends Enum<S>, V extends Enum<V>> SettingMapFactory<S, V> create(Class<S> settingsEnum, Class<V> statesEnum) {
        Objects.requireNonNull(settingsEnum, "settingsEnum");
        Objects.requireNonNull(statesEnum, "statesEnum");
        return SettingMapFactory.create((Setting[])((Setting[])settingsEnum.getEnumConstants()), (Setting.State[])((Setting.State[])statesEnum.getEnumConstants()));
    }

    public static <S extends Setting<V>, V extends Setting.State> SettingMapFactory<S, V> create(S[] settings, V[] states) {
        Objects.requireNonNull(settings, "settings");
        Objects.requireNonNull(states, "states");
        if (settings.length > 255) {
            throw new IllegalArgumentException("number of settings cannot be greater than 255");
        }
        if (states.length > 256) {
            throw new IllegalArgumentException("number of states cannot be greater than 256");
        }
        for (int i = 0; i < states.length; ++i) {
            V state = states[i];
            if (state.ordinal() == i) continue;
            throw new IllegalArgumentException("The ordinal of state " + state + " does not equal its array index. ordinal=" + state.ordinal() + ", index=" + i);
        }
        byte[] defaultStates = new byte[settings.length];
        for (int i = 0; i < settings.length; ++i) {
            S setting = settings[i];
            if (setting.ordinal() != i) {
                throw new IllegalArgumentException("The ordinal of setting " + setting + " does not equal its array index. ordinal=" + setting.ordinal() + ", index=" + i);
            }
            defaultStates[i] = (byte)setting.defaultState().ordinal();
        }
        return new SettingMapFactory(settings, states, defaultStates);
    }

    private SettingMapFactory(S[] settings, V[] states, byte[] defaultStates) {
        this.settings = settings;
        this.states = states;
        this.defaultStates = defaultStates;
    }

    public S[] getSettings() {
        return (Setting[])Arrays.copyOf(this.settings, this.settings.length);
    }

    public V[] getStates() {
        return (Setting.State[])Arrays.copyOf(this.states, this.states.length);
    }

    boolean isDifferentFromDefault(byte[] states) {
        return !Arrays.equals(this.defaultStates, states);
    }

    byte[] encode(byte[] states) {
        int n = 0;
        for (int i = 0; i < states.length; ++i) {
            byte state = states[i];
            byte defaultState = this.defaultStates[i];
            if (state == defaultState) continue;
            ++n;
        }
        if (n == 0) {
            return new byte[0];
        }
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        out.writeByte((int)((byte)n));
        for (int i = 0; i < states.length; ++i) {
            byte state = states[i];
            byte defaultState = this.defaultStates[i];
            if (state == defaultState) continue;
            byte settingOrdinal = (byte)i;
            out.writeByte((int)settingOrdinal);
            out.writeByte((int)state);
        }
        return out.toByteArray();
    }

    public SettingMap<S, V> newMap() {
        return new SettingMap(this, Arrays.copyOf(this.defaultStates, this.defaultStates.length));
    }

    public SettingMap<S, V> decode(byte[] buf) {
        if (buf.length == 0) {
            return this.newMap();
        }
        ByteArrayDataInput in = ByteStreams.newDataInput((byte[])buf);
        int n = Byte.toUnsignedInt(in.readByte());
        byte[] states = Arrays.copyOf(this.defaultStates, this.defaultStates.length);
        for (int i = 0; i < n; ++i) {
            byte stateByte;
            int settingOrdinal = Byte.toUnsignedInt(in.readByte());
            states[settingOrdinal] = stateByte = in.readByte();
        }
        return new SettingMap(this, states);
    }

    public SettingMap<S, V> decode(String encodedString) {
        return this.decode(ENCODING.decode((CharSequence)encodedString));
    }
}

