/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.plugin;

import me.lucko.helper.bossbar.BossBarFactory;
import me.lucko.helper.bossbar.BukkitBossBarFactory;
import me.lucko.helper.bossbar.ViaBossBarFactory;
import me.lucko.helper.hologram.BukkitHologramFactory;
import me.lucko.helper.hologram.HologramFactory;
import me.lucko.helper.hologram.individual.IndividualHologramFactory;
import me.lucko.helper.hologram.individual.PacketIndividualHologramFactory;
import me.lucko.helper.messaging.bungee.BungeeCord;
import me.lucko.helper.messaging.bungee.BungeeCordImpl;
import me.lucko.helper.npc.CitizensNpcFactory;
import me.lucko.helper.npc.NpcFactory;
import me.lucko.helper.plugin.ExtendedJavaPlugin;
import me.lucko.helper.scoreboard.PacketScoreboardProvider;
import me.lucko.helper.scoreboard.ScoreboardProvider;
import me.lucko.helper.signprompt.PacketSignPromptFactory;
import me.lucko.helper.signprompt.SignPromptFactory;
import org.bukkit.plugin.ServicePriority;

final class HelperServices {
    private HelperServices() {
    }

    static void setup(ExtendedJavaPlugin plugin) {
        BossBarFactory bossBarFactory;
        plugin.provideService(HologramFactory.class, new BukkitHologramFactory());
        plugin.provideService(BungeeCord.class, new BungeeCordImpl(plugin));
        if (plugin.isPluginPresent("ProtocolLib")) {
            PacketScoreboardProvider scoreboardProvider = new PacketScoreboardProvider(plugin);
            plugin.provideService(ScoreboardProvider.class, scoreboardProvider);
            plugin.provideService(PacketScoreboardProvider.class, scoreboardProvider);
            PacketSignPromptFactory signPromptFactory = new PacketSignPromptFactory();
            plugin.provideService(SignPromptFactory.class, signPromptFactory);
            try {
                PacketIndividualHologramFactory hologramFactory = new PacketIndividualHologramFactory();
                plugin.provideService(IndividualHologramFactory.class, hologramFactory);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (plugin.isPluginPresent("Citizens")) {
            CitizensNpcFactory npcManager = plugin.bind(new CitizensNpcFactory());
            plugin.provideService(NpcFactory.class, npcManager);
            plugin.provideService(CitizensNpcFactory.class, npcManager);
        }
        if (plugin.isPluginPresent("ViaVersion")) {
            bossBarFactory = new ViaBossBarFactory();
            plugin.provideService(BossBarFactory.class, bossBarFactory, ServicePriority.High);
        } else if (HelperServices.classExists("org.bukkit.boss.BossBar")) {
            bossBarFactory = new BukkitBossBarFactory(plugin.getServer());
            plugin.provideService(BossBarFactory.class, bossBarFactory);
        }
    }

    private static boolean classExists(String clazz) {
        try {
            Class.forName(clazz);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

