/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.menu.scheme;

import com.google.common.collect.Range;
import me.lucko.helper.item.ItemStackBuilder;
import me.lucko.helper.menu.scheme.EmptySchemeMapping;
import me.lucko.helper.menu.scheme.FunctionalSchemeMapping;
import me.lucko.helper.menu.scheme.SchemeMapping;
import me.lucko.helper.utils.annotation.NonnullByDefault;
import org.bukkit.Material;

@NonnullByDefault
public final class StandardSchemeMappings {
    private static final Range<Integer> COLORED_MATERIAL_RANGE = Range.closed((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(15));
    public static final SchemeMapping STAINED_GLASS = StandardSchemeMappings.forColoredMaterial(Material.STAINED_GLASS_PANE);
    public static final SchemeMapping STAINED_GLASS_BLOCK = StandardSchemeMappings.forColoredMaterial(Material.STAINED_GLASS);
    public static final SchemeMapping HARDENED_CLAY = StandardSchemeMappings.forColoredMaterial(Material.STAINED_CLAY);
    public static final SchemeMapping WOOL = StandardSchemeMappings.forColoredMaterial(Material.WOOL);
    public static final SchemeMapping EMPTY = new EmptySchemeMapping();

    private static SchemeMapping forColoredMaterial(Material material) {
        return FunctionalSchemeMapping.of(data -> ItemStackBuilder.of(material).name("&f").data(data).build(null), COLORED_MATERIAL_RANGE);
    }

    private StandardSchemeMappings() {
        throw new UnsupportedOperationException("This class cannot be instantiated");
    }
}

