/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.datatree;

import com.google.gson.JsonElement;
import java.util.Map;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import me.lucko.helper.config.ConfigurationNode;
import me.lucko.helper.datatree.ConfigurateDataTree;
import me.lucko.helper.datatree.GsonDataTree;

public interface DataTree {
    @Nonnull
    public static GsonDataTree from(@Nonnull JsonElement element) {
        return new GsonDataTree(element);
    }

    @Nonnull
    public static ConfigurateDataTree from(@Nonnull ConfigurationNode node) {
        return new ConfigurateDataTree(node);
    }

    @Nonnull
    public DataTree resolve(Object ... var1);

    @Nonnull
    public Stream<? extends Map.Entry<String, ? extends DataTree>> asObject();

    @Nonnull
    public Stream<? extends DataTree> asArray();

    @Nonnull
    public Stream<? extends Map.Entry<Integer, ? extends DataTree>> asIndexedArray();

    @Nonnull
    public String asString();

    @Nonnull
    public Number asNumber();

    public int asInt();

    public double asDouble();

    public boolean asBoolean();
}

