/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.datatree;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import me.lucko.helper.config.ConfigurationNode;
import me.lucko.helper.config.Types;
import me.lucko.helper.datatree.DataTree;

public class ConfigurateDataTree
implements DataTree {
    private final ConfigurationNode node;

    public ConfigurateDataTree(ConfigurationNode node) {
        this.node = Objects.requireNonNull(node, "node");
    }

    public ConfigurationNode getNode() {
        return this.node;
    }

    @Override
    @Nonnull
    public ConfigurateDataTree resolve(Object ... path) {
        return new ConfigurateDataTree(this.node.getNode(path));
    }

    @Nonnull
    public Stream<Map.Entry<String, ConfigurateDataTree>> asObject() {
        Preconditions.checkState((boolean)this.node.hasMapChildren(), (Object)"node does not have map children");
        return this.node.getChildrenMap().entrySet().stream().map(entry -> Maps.immutableEntry((Object)entry.getKey().toString(), (Object)new ConfigurateDataTree((ConfigurationNode)entry.getValue())));
    }

    @Nonnull
    public Stream<ConfigurateDataTree> asArray() {
        Preconditions.checkState((boolean)this.node.hasListChildren(), (Object)"node does not have list children");
        return this.node.getChildrenList().stream().map(ConfigurateDataTree::new);
    }

    @Nonnull
    public Stream<Map.Entry<Integer, ConfigurateDataTree>> asIndexedArray() {
        Preconditions.checkState((boolean)this.node.hasListChildren(), (Object)"node does not have list children");
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(new Iterator<Map.Entry<Integer, ConfigurateDataTree>>(){
            private final Iterator<? extends ConfigurationNode> iterator;
            private int index;
            {
                this.iterator = ConfigurateDataTree.this.node.getChildrenList().iterator();
                this.index = 0;
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public Map.Entry<Integer, ConfigurateDataTree> next() {
                return Maps.immutableEntry((Object)this.index++, (Object)new ConfigurateDataTree(this.iterator.next()));
            }
        }, 1040), false);
    }

    @Override
    @Nonnull
    public String asString() {
        return this.node.getValue(Types::asString);
    }

    @Override
    @Nonnull
    public Number asNumber() {
        return this.node.getValue(Types::asDouble);
    }

    @Override
    public int asInt() {
        return this.node.getValue(Types::asInt);
    }

    @Override
    public double asDouble() {
        return this.node.getValue(Types::asDouble);
    }

    @Override
    public boolean asBoolean() {
        return this.node.getValue(Types::asBoolean);
    }
}

