/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.config.typeserializers;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeToken;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.List;
import java.util.Map;
import me.lucko.helper.config.ConfigurationNode;
import me.lucko.helper.config.objectmapping.ObjectMappingException;
import me.lucko.helper.config.objectmapping.serialize.TypeSerializer;
import me.lucko.helper.gson.converter.GsonConverters;

public final class GsonTypeSerializer
implements TypeSerializer<JsonElement> {
    private static final TypeToken<JsonElement> TYPE = TypeToken.of(JsonElement.class);
    public static final GsonTypeSerializer INSTANCE = new GsonTypeSerializer();

    private GsonTypeSerializer() {
    }

    @Override
    public JsonElement deserialize(TypeToken<?> type, ConfigurationNode from) throws ObjectMappingException {
        if (from.getValue() == null) {
            return JsonNull.INSTANCE;
        }
        if (from.hasListChildren()) {
            List<? extends ConfigurationNode> childrenList = from.getChildrenList();
            JsonArray array = new JsonArray();
            for (ConfigurationNode configurationNode : childrenList) {
                array.add(configurationNode.getValue(TYPE));
            }
            return array;
        }
        if (from.hasMapChildren()) {
            Map<Object, ? extends ConfigurationNode> childrenMap = from.getChildrenMap();
            JsonObject object = new JsonObject();
            for (Map.Entry<Object, ? extends ConfigurationNode> entry : childrenMap.entrySet()) {
                object.add(entry.getKey().toString(), entry.getValue().getValue(TYPE));
            }
            return object;
        }
        Object val = from.getValue();
        try {
            return GsonConverters.IMMUTABLE.wrap(val);
        }
        catch (IllegalArgumentException e) {
            throw new ObjectMappingException(e);
        }
    }

    @Override
    public void serialize(TypeToken<?> type, JsonElement from, ConfigurationNode to) throws ObjectMappingException {
        if (from.isJsonPrimitive()) {
            JsonPrimitive primitive = from.getAsJsonPrimitive();
            to.setValue(GsonConverters.IMMUTABLE.unwarpPrimitive(primitive));
        } else if (from.isJsonNull()) {
            to.setValue(null);
        } else if (from.isJsonArray()) {
            JsonArray array = from.getAsJsonArray();
            to.setValue(ImmutableList.of());
            for (JsonElement element : array) {
                this.serialize(TYPE, element, to.getAppendedNode());
            }
        } else if (from.isJsonObject()) {
            JsonObject object = from.getAsJsonObject();
            to.setValue(ImmutableMap.of());
            for (Map.Entry ent : object.entrySet()) {
                this.serialize(TYPE, (JsonElement)ent.getValue(), to.getNode(ent.getKey()));
            }
        } else {
            throw new ObjectMappingException("Unknown element type: " + from.getClass());
        }
    }
}

